<?php
namespace NeoRenameBeta\NeoGlobal;




function json_encode_better($content_object, $pretty_print = false) { return json_encode($content_object, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_THROW_ON_ERROR | ($pretty_print ? JSON_PRETTY_PRINT : 0)); }



function php_to_js_object($php_object) { $js_object = json_encode_better($php_object); $js_object = preg_replace("/<\s*\/\s*script/i", "<\/script>", $js_object); return $js_object; }


function json_decode_better($json_string) {
    try {
        return json_decode($json_string, associative: true, flags: JSON_THROW_ON_ERROR);
    } catch (\JsonException $e) {
        throw new \NeoRenameBeta\NeoGlobal\GlobalException("JSON Decoding Error: " . $e->getMessage() . " Tried to decode: " . $json_string, 0, $e);
    }
}
