<?php
namespace NeoRenameBeta\NeoGlobal;




function slug_to_post_id($slug) {
    if ($slug === "" || $slug === null) { return null; }
    $post_type = null; if (str_contains($slug, "/")) { $exploded_slug = explode("/", $slug); $post_type = $exploded_slug[0]; $slug = $exploded_slug[1]; }
    global $wpdb;
    if ($post_type == null) { return $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_name = %s", $slug)); }
    else                    { return $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_name = %s AND post_type = %s", $slug, $post_type)); }
}


function slug_to_post($slug) {
    $post_id = slug_to_post_id($slug);
    if ($post_id == null) { return null; }
    return get_post($post_id);
}


function slug_to_url($slug) {
    $post_id = slug_to_post_id($slug);
    if ($post_id == null) { return null; }
    return wp_get_attachment_url($post_id);
}



function post_meta($post_id, $meta_key) {
    global $wpdb;
    $meta_value = $wpdb->get_var($wpdb->prepare("SELECT meta_value FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $post_id, $meta_key));
    if ($meta_value === null) { return null; }
    $meta_value = maybe_unserialize($meta_value);
    return $meta_value;
}
