<?php
namespace NeoRenameBeta\NeoGlobal;



function curl_request($url, $method = "GET", $data = null, $timeout = 30, $headers = [], $suppress_error = false) {
    if (!is_string($url) || $url === "") { throw new GlobalException("Invalid URL: " . $url); }
    
    $normalized_method = strtoupper($method);
    $args = [
        "method"  => $normalized_method,
        "headers" => [],
        "redirection" => 0,
    ];
    $args["timeout"] = $timeout;
    if ($timeout !== null && $timeout < 1.0) { $args["connect_timeout"] = $timeout; }
    
    if ($normalized_method === "GET") {
        if ($data !== null) {
            if (str_contains($url, "?")) { $url .= "&" . http_build_query($data); } else { $url .= "?" . http_build_query($data); }
        }
    } else if ($normalized_method === "POST") {
        $json_body = \NeoRenameBeta\NeoGlobal\json_encode_better($data);
        $args["body"] = $json_body;
        $headers["Content-Type"] = "application/json"; $headers["Content-Length"] = mb_strlen($json_body, "8bit");
    } else { throw new GlobalException("Invalid method: " . $method); }
    
    if (!isset($headers["User-Agent"])) { $headers["User-Agent"] = "neoCurl"; }
    $args["headers"] = $headers;
    
    try {
        $response = wp_remote_request($url, $args);
    } catch (\Throwable $e) {
        if ($suppress_error) { return false; }
        throw new \NeoRenameBeta\NeoGlobal\GlobalException("Fetch error for URL $url: " . $e->getMessage());
    }

    if (is_wp_error($response)) {
        if ($suppress_error) { return false; }
        throw new \NeoRenameBeta\NeoGlobal\GlobalException("Fetch error for URL $url: " . $response->get_error_message());
    }

    $status_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);
    
    if ($status_code === "" || $status_code === false || $status_code === null) {
        if ($suppress_error) { return false; }
        throw new \NeoRenameBeta\NeoGlobal\GlobalException("Fetch error for URL $url: Unable to retrieve HTTP status code (probably timeout)");
    }
    $status_code = intval($status_code);
    if (!($status_code >= 200 && $status_code <= 299)) { if ($suppress_error) { return false; } throw new GlobalException("Curl server error for URL $url: " . $status_code . "(response: $response_body)"); }
    return $response_body;
}
