<?php
namespace NeoRenameBeta\NeoGlobal;




function wp_date_timezone_string() { return wp_timezone()->getName(); }


function wp_date_string($format = "Y-m-d H:i:s", $timestamp = null) {
    if (!is_string($format)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid format: " . $format); }
    if ($timestamp !== null && !is_int($timestamp)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid timestamp: " . $timestamp); }
    $date_time = new \DateTime("@" . ($timestamp ?? time()));
    $date_time->setTimezone(wp_timezone());
    return $date_time->format($format);
}


function utc_date_string($format = "Y-m-d H:i:s", $timestamp = null) {
    if (!is_string($format)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid format: " . $format); }
    if ($timestamp !== null && !is_int($timestamp)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid timestamp: " . $timestamp); }
    return gmdate($format, $timestamp ?? time());
}


function timestamp_from_wp_date_string($date_string) {
    $date_time = \DateTime::createFromFormat("Y-m-d H:i:s", $date_string, wp_timezone());
    return $date_time->getTimestamp();
}
function timestamp_from_utc_date_string($date_string) {
    $date_time = \DateTime::createFromFormat("Y-m-d H:i:s", $date_string, new \DateTimeZone("UTC"));
    if ($date_time === false) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Could not convert date string to timestamp. Date string: " . $date_string . "."); }
    return $date_time->getTimestamp();
}


function unique_planck_date() {
    $micros = function () { $str = microtime(false); return substr($str, 11, 10) . substr($str, 2, 6); };
    $microtime_last = $micros();
    $microtime_next = $micros();
    while ($microtime_last === $microtime_next) { $microtime_next = $micros(); }
    $unix_sec = substr($microtime_next, 0, 10);
    $micro    = substr($microtime_next, 10, 6);
    $date_str = gmdate('YmdHis', $unix_sec) . $micro;
    $date_str .= str_pad(mt_rand(0, 999999), 6, "0", STR_PAD_LEFT) . str_pad(mt_rand(0, 999999), 6, "0", STR_PAD_LEFT);
    return $date_str;
}
