


export function extractJson(fetchResponseOrString) { 
    
    if (fetchResponseOrString.text) { 
        return (async () => { 
            const parsedJson = await fetchResponseOrString.text().then(extractJson); 
            
            if (!fetchResponseOrString.ok) { 
                if (parsedJson.message) { throw new Error(parsedJson.message); } 
                throw new Error(`REST API error ${fetchResponseOrString.status}: ${fetchResponseOrString}`); 
            }
            
            return parsedJson; 
        })();
    }
    
    let parsedJson = null; 
    let jsonStartIndex = 0; 
    for (jsonStartIndex = 0; jsonStartIndex < fetchResponseOrString.length; jsonStartIndex++) { 
        const char = fetchResponseOrString[jsonStartIndex]; 
        if (char === "{" || char === "[" || char === '"') { 
            try { parsedJson = JSON.parse(fetchResponseOrString.substring(jsonStartIndex)); break; } catch {} 
        }
    }
    if (!parsedJson) { throw new Error(`No JSON found in REST response: ${fetchResponseOrString}`); } 
    
    const phpWarningString = fetchResponseOrString.substring(0, jsonStartIndex); 
    if (phpWarningString) { console.warn(`PHP warning from REST endpoint: ${phpWarningString}`); } 
    
    return parsedJson; 
}
