<?php
namespace NeoRenameBeta\NeoGlobal;




function file_put_contents_better($file_path, $new_content) {
    if (file_exists($file_path)) {
        $current_content = file_get_contents($file_path);
        if ($current_content === $new_content) { return; }
    }
    $temp_file_path = \NeoRenameBeta\NeoGlobal\cache_path("file-helpers-temp") . "/" . str_replace("/", "__", $file_path);
    file_put_contents($temp_file_path, $new_content);
    rename($temp_file_path, $file_path);
}


function copy_all($src, $dest, $copy_filter_file_callback = null) {
    mkdir_better($dest);
    foreach (new \FilesystemIterator($src, \FilesystemIterator::SKIP_DOTS) as $file) {
        if ($file->isDir()) {
            copy_all($file->getPathname(), $dest . "/" . $file->getFilename(), $copy_filter_file_callback);
        } else {
            if (!($copy_filter_file_callback == null || $copy_filter_file_callback($file->getPathname()))) { continue; }
            $success = copy($file->getPathname(), $dest . "/" . $file->getFilename());
            if (!$success) { throw new GlobalException('Could not copy file "' . $file->getPathname() . '" to "' . $dest . "/" . $file->getFilename() . '"'); }
        }
    }
}


function delete_all($path, $filter = null) {
    if (str_contains($path, "*")) { $success = true; foreach (glob($path) as $file) { $success = $success && delete_all($file, $filter); } return $success; }
    if (!file_exists($path) && !is_link($path)) { return true; }
    if ($filter !== null && !$filter($path)) { return true; }
    if (is_file($path) || is_link($path)) {
        @unlink($path);
        $delete_success = !file_exists($path);
        return $delete_success;
    }
    if (!file_exists($path) && !is_link($path)) { return true; }
    
    $trash_dir_prefix = WP_CONTENT_DIR . "/cache/neowp_trash_";
    if (!str_starts_with($path, $trash_dir_prefix) && !$filter) {
        $success = rename($path, $trash_dir_prefix . \NeoRenameBeta\NeoGlobal\unique_planck_date() . "_" . basename($path));
        $trash_dirs = glob($trash_dir_prefix . "*"); shuffle($trash_dirs); foreach ($trash_dirs as $trash_dir) { $success = $success && delete_all($trash_dir); }
        return $success;
    }

    foreach (new \FilesystemIterator($path, \FilesystemIterator::SKIP_DOTS) as $file) {
        if (!delete_all($file->getPathname(), $filter)) { return false; }
    }

    if (!(is_dir($path) && !(new \FilesystemIterator($path))->valid())) {
        if ($filter !== null) { return true; }
        return false;
    }

    @rmdir($path);
    $delete_success = !file_exists($path);
    return $delete_success;
}


function remove_empty_directories($directory) {
    if (!is_dir($directory)) { return; }
    foreach (scandir($directory) as $entry) {
        if ($entry === "." || $entry === "..") { continue; }
        $path = $directory . DIRECTORY_SEPARATOR . $entry;
        if (is_dir($path)) { remove_empty_directories($path); }
    }
    if (count(\NeoRenameBeta\NeoGlobal\array_diff_better(scandir($directory), [".", ".."])) === 0) { rmdir($directory); }
}


function iterate_all_files($path, $with_folders = false): \Iterator {
    foreach (new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($path, \RecursiveDirectoryIterator::SKIP_DOTS), \RecursiveIteratorIterator::SELF_FIRST) as $file) {
        if (!$with_folders && !$file->isFile()) { continue; }
        yield $file->getPathname();
    }
}


function mkdir_better($path) {
    if (!str_starts_with($path, "/")) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Path must be absolute: $path"); }
    if (file_exists($path)) { return; }
    $path = untrailingslashit($path);
    $segments = explode("/", $path);
    $current = "/";
    foreach ($segments as $segment) {
        if ($segment === "") { continue; }
        $current = $current === "/" ? "/$segment" : "$current/$segment";
        if (file_exists($current)) { continue; }
        if (!mkdir($current)) {
            throw new \NeoRenameBeta\NeoGlobal\GlobalException(\NeoRenameBeta\NeoGlobal\neo__("Could not create directory \"$current\". Please check the permissions of the parent folder: " . dirname($current), "Konnte den Ordner \"$current\" nicht erstellen. Bitte überprüfe, ob alle Berechtigungen korrekt gesetzt sind: " . dirname($current)));
        }
        $parent = dirname($current);
        $base   = realpath($parent) ?: $parent;
        $perm   = fileperms($base) & 0777;
        if (!chmod($current, $perm)) {
            throw new \NeoRenameBeta\NeoGlobal\GlobalException("Could not set permissions on directory \"$current\"");
        }
    }
    clearstatcache(true);
}
