
export async function neoLoadInterfaceFunc(callingPluginSlug, importPath, functionName) { 
    const interfaceModuleUrls = window.neoInterfaceModuleUrls_NEO_RENAME_BETA; 
    if (!interfaceModuleUrls) { throw new Error("neoWP: Incompatible function call. Make sure that all of your neoPlugins are up to date."); } 
    let moduleUrl = null; for (const [baseUrl, jsRelPaths] of Object.entries(interfaceModuleUrls)) { if (jsRelPaths.includes(importPath)) { moduleUrl = baseUrl + "/" + importPath; break; } } 
    if (!moduleUrl) { throw new Error("neoWP: Incompatible function call. Make sure that all of your neoPlugins are up to date."); } 
    const module = await import(moduleUrl); 
    if (!module[functionName]) { throw new Error("neoWP: Incompatible function call. Make sure that all of your neoPlugins are up to date."); } 
    return module[functionName]; 
}
