<?php
namespace NeoRenameBeta\NeoGlobal;







function call_interface_func($result, $throw_if_interface_not_ok = false) {
    if (!is_interface_system_available()) { throw new \Exception("You can only call an interface function after the neo_init hook because only then all plugins are loaded. " . "(called from " . (debug_backtrace()[1]["file"] ?? "?") . ", line " . (debug_backtrace()[1]["line"] ?? "?") . ")"); }
    if ($throw_if_interface_not_ok) { return $result; }
    return [$result, true];
}

function call_interface_func_bundled($function_name_with_namespace, $throw_if_interface_not_ok = false) {
    if (!is_interface_system_available()) { trigger_error("You can only call an interface function ($function_name_with_namespace) after the neo_init hook because only then all plugins are loaded. " . "(called from " . (debug_backtrace()[1]["file"] ?? "?") . ", line " . (debug_backtrace()[1]["line"] ?? "?") . ")"); return [null, false]; }
    
    $module_namespace = explode("\\", $function_name_with_namespace)[2];
    $function_name    = explode("\\", $function_name_with_namespace)[3];
    foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $active_plugin) {
        $plugin_namespace_prefix = $active_plugin["namespace_prefix"];
        if ($module_namespace === "Custom") { $module_namespace = ""; }
        $full_function_name_in_active_plugin = "\\" . $plugin_namespace_prefix . $module_namespace . "\\" . $function_name;
        if (function_exists($full_function_name_in_active_plugin)) {
            return function (...$args) use ($full_function_name_in_active_plugin, $throw_if_interface_not_ok) { return $throw_if_interface_not_ok ? $full_function_name_in_active_plugin(...$args) : [$full_function_name_in_active_plugin(...$args), true]; };
        }
    }
    if ($throw_if_interface_not_ok) { throw new \Exception("The interface function $function_name_with_namespace does not exist in any active neoPlugin. " . "(called from " . (debug_backtrace()[1]["file"] ?? "?") . ", line " . (debug_backtrace()[1]["line"] ?? "?") . ")"); }
    return function (...$args) { return [null, false]; };
}


function is_interface_system_available() { return did_action("neo_init"); }


function is_module_available($module_name) {
    if (!is_interface_system_available()) { return false; }
    foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $active_plugin) {
        if (isset($active_plugin["module_files"][$module_name])) { return true; }
    }
    return false;
}


\NeoRenameBeta\NeoGlobal\add_action_hook("wp_head", "admin_head", function () {
    
    $interface_module_rel_paths = [];
    foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $active_plugin) {
        $plugin_namespace_prefix = $active_plugin["namespace_prefix"] ?? null;
        if ($plugin_namespace_prefix === null) { continue; }
        if (!function_exists("\\" . $plugin_namespace_prefix . "NeoGlobal\\plugin_url")) { continue; }
        $plugin_url = null; try { $plugin_url = ("\\" . $plugin_namespace_prefix . "NeoGlobal\\plugin_url")(); } catch (\Throwable $err) {}
        if ($plugin_url === null) { continue; }
        $plugin_path = $active_plugin["plugin_path"] ?? null;
        if ($plugin_path === null) { continue; }
        foreach (\NeoRenameBeta\NeoGlobal\iterate_all_files($plugin_path) as $filepath) {
            if (!str_ends_with($filepath, ".js")) { continue; }
            if (str_contains($filepath, "thirdparty")) { continue; }
            $rel_path = \NeoRenameBeta\NeoGlobal\make_plugin_file_path_relative($filepath);
            if (isset($interface_module_rel_paths[$rel_path])) { continue; }
            $interface_module_rel_paths[$rel_path] = $plugin_url;
        }
    }

    $interface_module_urls = []; foreach ($interface_module_rel_paths as $rel_path => $url) { $interface_module_urls[$url][] = $rel_path; }
    ?><script>window.neoInterfaceModuleUrls_NEO_RENAME_BETA = <?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object($interface_module_urls) ?>;</script><?php 
});
