













function hashStringForObserver(str) { const hashDjb2 = (str) => { let hash = 5381; for (let i = 0; i < str.length; i++) { hash = ((hash << 5) + hash) + str.charCodeAt(i); } hash = Math.abs(hash).toString(16).padStart(8, "0"); return hash; }; const hash1 = hashDjb2(str); const hash2 = hashDjb2(hash1 + str); return hash1 + hash2; } 

export function observeOnce(selector, callback, callbackSalt="") { 
    observeOnce.observerRegistry ??= []; 
    
    const uniqueKey = hashStringForObserver(`${selector}|${callback.toString()}|${callbackSalt}`); 
    if (observeOnce.observerRegistry.some(entry => entry.uniqueKey === uniqueKey)) { return; } 
    const newObserverEntry = { uniqueKey, selector, callback, processedNodes: new Set() }; observeOnce.observerRegistry.push(newObserverEntry); 
    
    for (const node of document.querySelectorAll(selector)) { newObserverEntry.processedNodes.add(node); callback(node); } 
    
    observeOnce.observer ??= new MutationObserver(async mutations => { 
        
        observeOnce.semaphore = true; 
        await new Promise(resolve => requestAnimationFrame(resolve)); 
        if (!observeOnce.semaphore) { return; } 
        observeOnce.semaphore = false; 
        
        for (const registryEntry of observeOnce.observerRegistry) { 
            for (const node of document.querySelectorAll(registryEntry.selector)) { 
                if (registryEntry.processedNodes.has(node)) { continue; } 
                registryEntry.processedNodes.add(node); 
                registryEntry.callback(node); 
            }
        }
    }).observe(document.querySelector("html"), { childList: true, subtree: true }); 
}

export function observeInViewportOnce(node, callback, rootMargin = "0px") { 
    if (typeof node === "string") { observeOnce(node, (node) => { observeInViewportOnce(node, callback, rootMargin); }, hashStringForObserver(callback.toString())); return; } 
    
    new IntersectionObserver((entries, observer) => { entries.forEach(entry => { 
        if (entry.isIntersecting) { callback(entry.target); observer.disconnect(); } 
    }); }, { rootMargin: rootMargin }).observe(node); 
}

export async function observeUserInteractionOnce(callback) { 
    if (navigator.userAgent.includes("HeadlessChrome")) { return; } 
    await domLoaded(); 
    const _ = "./_global--observer.php"; 
    await neoFirstInteractionPromise_NEO_RENAME_BETA; 
    if (callback) { callback(); } 
}

export async function observeScrollOnce(callback) { 
    await domLoaded(); 
    await observeUserInteractionOnce(); 
    await new Promise(resolve => window.addEventListener("scroll", evt => {console.log(evt); resolve()}, { once: true, passive: true })); 
    if (callback) { callback(); } 
}

export function observeAttributes(node, callback) { 
    if (typeof node === "string") { observeOnce(node, (node) => { observeAttributes(node, callback); }, hashStringForObserver(callback.toString())); return; } 
    new MutationObserver(mutations => { callback(node); }).observe(node, { attributes: true, childList: false, subtree: false, characterData: false }); 
    callback(node); 
}

export function observeNode(node, callback) { 
    if (typeof node === "string") { observeOnce(node, (node) => { observeNode(node, callback); }, hashStringForObserver(callback.toString())); return; } 
    new MutationObserver(mutations => { callback(node); }).observe(node, { attributes: true, childList: true, subtree: true, characterData: true }); 
    callback(node); 
}

export function observeResize(node, callback) { 
    if (typeof node === "string") { observeOnce(node, (node) => { observeResize(node, callback); }, hashStringForObserver(callback.toString())); return; } 
    let nodeWidth, nodeHeight; 
    new ResizeObserver((entries) => { entries.forEach((entry) => { 
        const { width, height } = entry.contentRect; 
        if (nodeWidth === width && nodeHeight === height) { return; } 
        nodeWidth = width; nodeHeight = height; 
        callback(node, { width, height }); 
    });}).observe(node); 
}

export function observeClick(node, callback) { 
    if (typeof node === "string") { observeOnce(node, (node) => { observeClick(node, callback); }, hashStringForObserver(callback.toString())); return; } 
    node.addEventListener("click", () => callback(node)); 
}

export async function domLoaded(callback) { 
    if (document.readyState === "loading") { await new Promise(resolve => window.addEventListener("DOMContentLoaded", resolve)); } 
    if (callback) { callback(); } 
}

export async function delay(time, callback) { 
    await domLoaded(); 
    await new Promise(resolve => setTimeout(resolve, time * 1000)); 
    if (callback) { callback(); } 
}
