<?php
namespace NeoRenameBeta\NeoGlobal;





function is_performance_measure_on() { return isset($_GET["neoperformance"]); }


$GLOBALS["neo_global_performance_NEO_RENAME_BETA"] = [];
function performance_checkpoint($message, $caller_rel_path = null, $time = null, $is_start = false, $is_end = false) {
    if (!is_performance_measure_on()) { return; }
    $time ??= microtime(true);
    $caller_rel_path ??= get_caller_rel_path();
    static $pid = null; $pid ??= getmypid();
    $php_process_log_path = "/var/www/php-processes/php-process-pid-map_pid" . $pid . ".txt";
    
    $overwrite_second_line_in_php_process_log = function ($perf_message) use ($php_process_log_path) {
        if (!file_exists($php_process_log_path)) { return; }
        $fp = fopen($php_process_log_path, "r+");
        $first_line = fgets($fp);
        fseek($fp, strlen($first_line) + 1);
        fwrite($fp, $perf_message);
        ftruncate($fp, ftell($fp));
        fclose($fp);
    };
    if ($is_start) {
        $GLOBALS["neo_global_performance_NEO_RENAME_BETA"][] = ["time" => $time, "path" => "[Other files]", "message" => "[Other code]"];
        $overwrite_second_line_in_php_process_log("$caller_rel_path $message");
    } else if ($is_end) {
        $GLOBALS["neo_global_performance_NEO_RENAME_BETA"][] = ["time" => $time, "path" => $caller_rel_path, "message" => $message];
        $overwrite_second_line_in_php_process_log("[Other file] [Other code]");
    } else {
        $GLOBALS["neo_global_performance_NEO_RENAME_BETA"][] = ["time" => $time, "path" => $caller_rel_path, "message" => $message];
        $overwrite_second_line_in_php_process_log("$caller_rel_path $message");
    }
}


add_action("shutdown", function () {
    performance_checkpoint("shutdown", is_end: true);
    if (!is_performance_measure_on()) { return; }
    
    $performance_table = [];
    $max_path_length   = 0;
    $runtime_max       = 0.0;
    
    foreach ($GLOBALS["neo_global_performance_NEO_RENAME_BETA"] as $i => $entry) {
        $diff_prev = 0.0; $diff_start = 0.0;
        if ($i !== 0) {
            $diff_prev  = round($entry["time"] - $GLOBALS["neo_global_performance_NEO_RENAME_BETA"][$i - 1]["time"], 5);
            $diff_start = round($entry["time"] - $GLOBALS["neo_global_performance_NEO_RENAME_BETA"][0]["time"], 5);
        }
        $performance_table[] = ["message" => $entry["message"], "path" => $entry["path"], "diff_prev" => $diff_prev, "diff_start" => $diff_start];
        $runtime_max = max($runtime_max, $diff_prev);
        $current_length = strlen($entry["path"]);
        if ($current_length > $max_path_length) { $max_path_length = $current_length; }
    }
    $path_width = ($max_path_length > 60) ? 60 : $max_path_length;
    $total_runtime  = count($performance_table) ? end($performance_table)["diff_start"] : 0;
    $total_requests = count($performance_table);

    
    $count_map = [];
    foreach ($performance_table as $row) { $key = $row["path"] . "\x00" . $row["message"]; $count_map[$key] ??= 0; $count_map[$key]++; }
    $table1 = [];
    foreach ($performance_table as $row) {
        $count = $count_map[$row["path"] . "\x00" . $row["message"]];
        $table1[] = ["path" => $row["path"], "message" => $row["message"], "diff_start" => $row["diff_start"], "diff" => $row["diff_prev"], "count" => $count];
    }
    usort($table1, function ($a, $b) { return $a["diff_start"] <=> $b["diff_start"]; });

    
    $table2_assoc = [];
    foreach ($performance_table as $row) {
        $key = trim($row["path"]) . "\x00" . trim($row["message"]);
        $table2_assoc[$key] ??= ["path" => $row["path"], "message" => $row["message"], "diff_start" => $row["diff_start"], "diff" => 0, "count" => 0];
        $table2_assoc[$key]["count"]++;
        $table2_assoc[$key]["diff"] += $row["diff_prev"];
        if ($row["diff_start"] < $table2_assoc[$key]["diff_start"]) { $table2_assoc[$key]["diff_start"] = $row["diff_start"]; }
    }
    $table2 = array_values($table2_assoc);
    usort($table2, function ($a, $b) { return $b["diff"] <=> $a["diff"]; });

    
    function build_table_string($data, $with_summary = false, $total_runtime = 0, $max_diff = 0, $path_width = 10) {
        $table = sprintf("%7s %7s %7s %-" . $path_width . "s %s", "START", "DIFF", "COUNT", "PATH", "MESSAGE") . "\n";
        foreach ($data as $row) {
            $path = (strlen($row["path"]) > $path_width) ? substr($row["path"], 0, $path_width) : $row["path"];
            $table .= sprintf("%7.3f %7.3f %7d %-" . $path_width . "s %s", $row["diff_start"], $row["diff"], $row["count"], $path, $row["message"]) . "\n";
        }
        if ($with_summary) { $table .= sprintf("TOTAL: %7.3f s, MAX DIFF: %7.3f s", $total_runtime, $max_diff) . "\n"; }
        return $table;
    }

    $table_string1 = build_table_string($table1,  with_summary: true,  total_runtime: $total_runtime, max_diff: $runtime_max, path_width: $path_width);
    $table_string2 = build_table_string($table2,  with_summary: false, total_runtime: 0,              max_diff: 0,            path_width: $path_width);
    $table_string3 = "Total Runtime: " . $total_runtime . "s\nTotal Count: " . $total_requests . "\n";
    $table_string1 = "### " . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . " - Performance Log (START) ###"    . "\n" . $table_string1;
    $table_string2 = "### " . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . " - Aggregated Performance Log ###" . "\n" . $table_string2;
    $table_string3 = "### " . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . " - Performance Summary ###"        . "\n" . $table_string3;
    ?>
    <script>
        console.log(<?php echo json_encode($table_string1, JSON_UNESCAPED_SLASHES); ?>); 
        console.log(<?php echo json_encode($table_string2, JSON_UNESCAPED_SLASHES); ?>); 
        console.log(<?php echo json_encode($table_string3, JSON_UNESCAPED_SLASHES); ?>); 
    </script>
<?php }, PHP_INT_MAX);


function get_caller_rel_path() {
    $plugin_dir = dirname(__FILE__);
    $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);
    
    foreach ($backtrace as $frame) {
        if (!isset($frame["file"])) { continue; }
        if ($frame["file"] === __FILE__) { continue; }
        if (str_ends_with($frame["file"], "/_global--better-wp-functions" . ".php"))      { continue; }
        if (str_ends_with($frame["file"], "/neo-website-1-shortcode-with-echo" . ".php")) { continue; }
        if (str_starts_with($frame["file"], $plugin_dir . "/")) { return str_replace($plugin_dir . "/", "", $frame["file"]) . ":" . ($frame["line"] ?? 0); }
    }
    return "[Unknown]";
}







function add_action_hook(...$args) {
    _multiple_hook_registration(false, ...$args);
}







function add_filter_hook(...$args) {
    _multiple_hook_registration(true, ...$args);
}


function _multiple_hook_registration(bool $use_filter, ...$args) {
    if (count($args) < 2) { throw new \InvalidArgumentException("Error: Too few parameters."); }
    $callback = array_pop($args);
    if (is_int($callback)) { throw new \InvalidArgumentException("Error: Last parameter is an integer. Provide the priority in the hook name (e.g. admin_init:20) and omit the number of function parameters (found using reflection)."); }
    if (!$callback instanceof \Closure) { throw new \InvalidArgumentException("Error: Last parameter is no anonymous function (Closure)."); }
    if (empty($args)) { throw new \InvalidArgumentException("Error: No hooks found."); }
    
    $num_params = (new \ReflectionFunction($callback))->getNumberOfParameters();
    $caller_rel_path = is_performance_measure_on() ? get_caller_rel_path() : null;
    foreach ($args as $hook_name_with_prio) {
        if (is_int($hook_name_with_prio)) { throw new \InvalidArgumentException("Error: Hook name is an integer. Provide the priority in the hook name (e.g. admin_init:20) and omit the number of function parameters (found using reflection)."); }
        if (!is_string($hook_name_with_prio)) { throw new \InvalidArgumentException("Error: Hook name is not a string."); }
        $hook_name = explode(":", $hook_name_with_prio)[0];
        $hook_prio = explode(":", $hook_name_with_prio)[1] ?? "10"; if ($hook_prio === "max") { $hook_prio = PHP_INT_MAX; } else { $hook_prio = intval($hook_prio); }
        ($use_filter ? "add_filter" : "add_action")($hook_name, function (...$args) use ($hook_name, $callback, $caller_rel_path) {
            return \NeoRenameBeta\NeoEntrypoint\suppress_plugin_on_error(function () use (&$use_filter, &$hook_name, &$caller_rel_path, &$callback, &$args) {
                performance_checkpoint("hook " . ($use_filter ? "filter" : "action") . " " . $hook_name, caller_rel_path: $caller_rel_path, is_start: true);
                $value = $callback(...$args);
                performance_checkpoint("hook " . ($use_filter ? "filter" : "action") . " " . $hook_name, caller_rel_path: $caller_rel_path, is_end: true);
                return $value;
            });
        }, $hook_prio, $num_params);
    }
}


function add_shortcode_hook($tag, $callback) {
    $caller_rel_path = is_performance_measure_on() ? get_caller_rel_path() : null;
    return add_shortcode($tag, function ($atts = [], $content = null) use ($tag, $callback, $caller_rel_path) {
        $value = null; \NeoRenameBeta\NeoEntrypoint\suppress_plugin_on_error(function () use (&$tag, &$atts, &$content, &$caller_rel_path, &$value, &$callback) {
            performance_checkpoint("shortcode [$tag]", caller_rel_path: $caller_rel_path, is_start: true);
            $value = $callback($atts, $content);
            performance_checkpoint("shortcode [$tag]", caller_rel_path: $caller_rel_path, is_end: true);
        });
        return $value;
    });
}
