<?php
namespace NeoRenameBeta\NeoGlobal;












function synclock_dir($dir, $callback, $timeout = 1.0, $scope = null) {
    if (!file_exists($dir)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Directory does not exist in neo_synclock_dir. Path: " . $dir . ". Scope: $scope" . "."); return; }
    
    $ignore_all_warnings_and_errors = function ($callback) {
        
        try {
            set_error_handler(function ($errno, $errstr, $errfile, $errline) {});
            $callback();
        } finally {
            restore_error_handler();
        }
    };

    try {
        
        $dir = untrailingslashit($dir) . "/";
        if ($scope && strlen($scope) > 16) { $scope = substr($scope ?? "", 0, 8) . "..." . substr($scope, -8) . "-" . substr(md5($scope), 0, 8); }
        $scope_filename_part = $scope === null ? "" : "-$scope";
        $lock_file = $dir . ".lock$scope_filename_part-" . \NeoRenameBeta\NeoGlobal\unique_planck_date();
        $touch_success = touch($lock_file);
        if (!$touch_success) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Could not create lock file in neo_synclock_dir. Path: " . $dir . ". Scope: $scope" . "."); }
        while (basename($lock_file) !== basename((function($files){ sort($files); return $files[0] ?? ""; })(glob($dir . ".lock$scope_filename_part-*")))) {
            $touch_success = touch($lock_file);
            if (!$touch_success) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Could not touch lock file in neo_synclock_dir. Path: " . $dir . ". Scope: $scope" . "."); }
            
            $ignore_all_warnings_and_errors(function() use ($dir, $timeout, $scope_filename_part) {
                foreach (glob($dir . ".lock$scope_filename_part-*") as $filename) { if (filemtime($filename) < time() - $timeout) { unlink($filename); } }
            });
            usleep(1000);
        }

        return $callback();
    } finally {
        if (!file_exists($lock_file)) { \NeoRenameBeta\NeoGlobal\global_warn("This PHP process took too long in neo_synclock_dir. It was cleaned up by another PHP process. Path: " . $dir . ". Scope: $scope" . ". Stack trace: " . debug_backtrace()[0]["file"] . " " . debug_backtrace()[0]["line"]); }
        else { $ignore_all_warnings_and_errors(fn () => unlink($lock_file)); }
    }
}
