




export function addQueryParams(url, params) { 
    if (Object.keys(params).length === 0) { return url; } 
    if (url.startsWith("blob:")) { throw new Error("Blob URLs cannot have query params."); } 
    params = {...params}; for (const key in params) { if (typeof params[key] === "object" && params[key] != null) { params[key] = JSON.stringify(params[key]); } } 
    const queryParts = []; for (const [key, value] of Object.entries(params)) { if (value === null || value === undefined) { queryParts.push(encodeURIComponent(key)); } else if (value === "") { queryParts.push(encodeURIComponent(key) + "="); } else { queryParts.push(encodeURIComponent(key) + "=" + encodeURIComponent(String(value))); } } 
    const queryString = queryParts.join("&"); 
    const [baseUrl, hash] = url.split("#"); 
    if (baseUrl.includes("?")) { url = baseUrl + "&" + queryString; } 
    else                       { url = baseUrl + "?" + queryString; } 
    if (hash) { url += "#" + hash; } 
    return url;
}


export function addQueryParam(url, key, value = null) { 
    if (key !== key.toLowerCase() || key.includes("_")) { throw new Error("Convention violated: Query param key must be lowercase and without underscores."); } 
    return addQueryParams(url, {[key]: value}); 
}


export function addCacheBust(url, date = -1) { 
    if (!date) { return url; } 
    if (date === -1) { return addCacheBust(url, Date.now()); } 
    if (url.startsWith("blob:")) { return url; } 
    return addQueryParam(url, "cachebust", date); 
}


export function getQueryParams(url) { 
    if (!url.includes("?")) { return {}; } 
    return Object.fromEntries(new URLSearchParams(url.split("?")[1].split("#")[0]).entries()); 
}


export function getQueryParam(url, key) { 
    return getQueryParams(url)[key]; 
}


export function hasQueryParam(url, key) { 
    return key in getQueryParams(url); 
}


export function removeQueryParam(url, key) { 
    const params = getQueryParams(url); 
    delete params[key]; 
    url = removeAllQueryParams(url); 
    return addQueryParams(url, params); 
}


export function removeAllQueryParams(url) { 
    return url.split("?")[0] + (url.includes("#") ? "#" + url.split("#")[1] : ""); 
}


export function fitProtocolToFetchImgUrl(url) { 
    
    
    if (url.startsWith("http:") && location.protocol === "https:") { url = url.replace("http:", "https:"); } 
    return url; 
}


export function getUrlFilename(url) { 
    return url.split("/").pop().split("?")[0].split("#")[0]; 
}
