<?php
namespace NeoRenameBeta\NeoGlobal;




function get_url_path($url) {
    return parse_url($url, PHP_URL_PATH) ?? "";
}


function get_url_with_correct_slash($url) {
    [$url_base, $url_fragment] = str_contains($url, "#") ? explode("#", $url) : [$url, ""];
    [$url_base, $url_query] = str_contains($url_base, "?") ? explode("?", $url_base) : [$url_base, ""];
    if (preg_match("/\.[a-zA-Z0-9]+\/?$/", get_url_path($url_base)) || $url_base === "") { return untrailingslashit($url_base) . ($url_query ? "?" . $url_query : "") . ($url_fragment ? "#" . $url_fragment : ""); }
    if (str_contains($url_base, "/wp-")) { return $url; }
    if (substr($url_base, -1) != "/") { $url_base .= "/"; }
    return $url_base . ($url_query ? "?" . $url_query : "") . ($url_fragment ? "#" . $url_fragment : "");
}


function is_url_internal($url) {
    return str_starts_with($url, "/") || str_starts_with($url, "?") || str_starts_with($url, "javascript:") || str_starts_with($url, "mailto:") || str_starts_with($url, "tel:") || str_starts_with($url, "#") || is_url_internal_and_absolute($url);
}

function is_url_internal_and_absolute($url) {
    return str_starts_with($url, str_replace("https://", "http://", get_site_url())) || str_starts_with($url, str_replace("http://", "https://", get_site_url()));
}


function make_url_absolute($url) {
    if (substr($url, 0, 1) == "/") { $url = get_site_url() . $url; }
    return $url;
}


function make_url_relative($url) {
    $site_url = get_site_url();
    if (str_starts_with($url, $site_url)) {
        return substr($url, strlen($site_url));
    }
    return $url;
}


function get_query_param_from_url($url, $param) {
    $query = parse_url($url, PHP_URL_QUERY);
    if (!$query) { return null; }
    parse_str($query, $params);
    return $params[$param] ?? null;
}
