<?php
namespace NeoRenameBeta\NeoGlobal;








register_activation_hook(\NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path(), function () {
    if (!(str_starts_with($_SERVER["REQUEST_URI"], "/wp-admin/plugins.php") && str_contains($_SERVER["REQUEST_URI"], "action=activate"))) { return; }
    
    update_option("neo-global-after-activation-redirect-NEO_RENAME_BETA", "true");
});

\add_action("neo_init", function () {
    \NeoRenameBeta\NeoGlobal\add_action_hook("current_screen", function () {
        if (!(get_option("neo-global-after-activation-redirect-NEO_RENAME_BETA") === "true")) { return; }
        delete_option("neo-global-after-activation-redirect-NEO_RENAME_BETA");
        if (\NeoRenameBeta\NeoGlobal\is_playground()) { return; }
        wp_safe_redirect(admin_url("admin.php?page=" . \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug()));
        exit;
    });
});

\add_action("neo_init", function () { \NeoRenameBeta\NeoGlobal\freemius_instance()?->add_filter("redirect_on_activation", function () { return false; }); });




function neo_deactivate_hook() {
    \NeoRenameBeta\NeoGlobal\add_action_hook("shutdown", function() {
        
        if (count(glob(\NeoRenameBeta\NeoGlobal\cache_path() . "/custom-*")) > 0) { return; }
        
        $delete_success = \NeoRenameBeta\NeoGlobal\delete_all(\NeoRenameBeta\NeoGlobal\cache_path());
        if (!$delete_success) { trigger_error("Could not delete cache folder " . \NeoRenameBeta\NeoGlobal\cache_path()); }
    });
}
register_deactivation_hook(\NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path(), "\\" . __NAMESPACE__ . "\\" . "neo_deactivate_hook");

\add_action("neo_init", function () {
    \NeoRenameBeta\NeoGlobal\add_filter_hook("upgrader_post_install", function ($response, $hook_extra, $result) {
        if (!($result["destination_name"] === \NeoRenameBeta\NeoGlobal\get_bundle_slug(\NeoRenameBeta\NeoEntrypoint\plugin_slug(), \NeoRenameBeta\NeoEntrypoint\plugin_edition()))) { return $response; }
        neo_deactivate_hook();
        return $response;
    });
});



function delete_all_plugin_options() {
    foreach (array_keys(wp_load_alloptions()) as $option_name) {
        if (!str_starts_with($option_name, "neo-")) { continue; }
        if (in_array($option_name, ["neo-toolsync-target-hostnames", "neo-toolsync-post-slugs", "neo-toolsync-option-names", "neo-toolsync-pw", "neo-toolcode", "neo-bundler-domain-settings"])) { continue; }
        delete_option($option_name);
    }
}
function neo_uninstall_hook() {
    
    foreach (get_plugins() as $plugin_file => $plugin_data) {
        if (dirname(WP_PLUGIN_DIR . "/" . $plugin_file) === dirname(__FILE__)) { continue; }
        if (!str_starts_with($plugin_file, "neo-")) { continue; }
        return;
    }

    delete_all_plugin_options();
}

(function () {
    $freemius_instance_function = '\Neo' . 'Global\freemius' . '_instance';
    
    if (function_exists($freemius_instance_function) && $freemius_instance_function() !== null) {
        $freemius_instance_function()->add_action("after_uninstall", function () { neo_uninstall_hook(); });
    } else {
        register_uninstall_hook(\NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path(), "\\" . __NAMESPACE__ . "\\" . "neo_uninstall_hook");
    }
})();
