<?php
namespace NeoRenameBeta\NeoGlobal;


function activate_image_cache_bust() {
    static $already_registered = false;
    if ($already_registered) { return; } $already_registered = true;
    \NeoRenameBeta\NeoGlobal\frontend_image_hook_register_callback(function ($get_attr, $set_attr, $image_file_path) {
        $src = $get_attr("src");
        if (isset(parse_url($src)["query"]["neo-cachebust"])) { \NeoRenameBeta\NeoGlobal\global_warn("Cachebust already set in image URL: $src"); return; }
        $set_attr("src", add_query_arg("neo-cachebust", filemtime($image_file_path), $src));
    });
}
