<?php
namespace NeoRenameBeta\NeoGlobal;
















function get_plugin_slug                                  ($filename_or_path)                       { preg_match('/(?P<plugin_slug>.*?)(?:-(?P<edition>full|pro|beta))?\.(?P<version>.*?)\.zip/', basename($filename_or_path), $m); return $m["plugin_slug"]; }
function get_plugin_edition                               ($filename_or_path)                       { preg_match('/(?P<plugin_slug>.*?)(?:-(?P<edition>full|pro|beta))?\.(?P<version>.*?)\.zip/', basename($filename_or_path), $m); return $m["edition"] ?: "store"; }
function get_plugin_version                               ($filename_or_path)                       { preg_match('/(?P<plugin_slug>.*?)(?:-(?P<edition>full|pro|beta))?\.(?P<version>.*?)\.zip/', basename($filename_or_path), $m); return $m["version"]; }

function get_plugin_name                                  ($plugin_slug, $edition)                  { $rules = ["Neo"=>"neo", "Tool"=>"Tool "]; return implode("", array_map(function($p) use($rules) { return $rules[ucfirst($p)]??ucfirst($p);}, explode("-",$plugin_slug))) . (in_array($edition, ["beta", "pro"]) ? (" " . ucfirst($edition)) : ""); }
function get_plugin_seo_name                              ($plugin_slug, $edition)                  { return str_replace("neo", "neo ", get_plugin_name($plugin_slug, $edition)); }

function get_bundle_slug                                  ($plugin_slug, $edition)                  { return $plugin_slug . ($edition === "store" ? "" : "-$edition"); }

function get_zip_file_name_prefix                         ($plugin_slug, $edition)                  { return get_bundle_slug($plugin_slug, $edition); }
function get_zip_file_name_without_version                ($plugin_slug, $edition)                  { return get_zip_file_name_prefix($plugin_slug, $edition) . ".zip"; }
function get_zip_file_name                                ($plugin_slug, $edition, $version)        { if (!$version) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("No version given. Use get_zip_file_name_without_version() to get the ZIP file name without a version number."); } return get_zip_file_name_prefix($plugin_slug, $edition) . "." . $version . ".zip"; }
function get_plugin_cache_folder_name                     ($plugin_slug, $edition)                  { return "$plugin_slug-$edition" . cache_server_username_suffix(); }
function get_plugin_folder_name                           ($plugin_slug)                            { return $plugin_slug; }
function get_plugin_entry_file_name                       ($plugin_slug)                            { return $plugin_slug . ".php"; }
function get_plugin_entry_json_file_name                  ($plugin_slug)                            { return str_replace(".php", ".json", get_plugin_entry_file_name($plugin_slug)); }
function get_plugin_entry_path_relative                   ($plugin_slug)                            { return get_plugin_folder_name($plugin_slug) . "/" . get_plugin_entry_file_name($plugin_slug); }
function get_plugin_info_json_file_name                   ($plugin_slug, $edition)                  { return get_bundle_slug($plugin_slug, $edition) . "-info.json"; }
function get_plugin_info_json_file_url                    ($plugin_slug, $edition)                  { return "https://download.neo-wp.com/" . get_plugin_info_json_file_name($plugin_slug, $edition); }
function get_plugin_download_zip_file_url_without_version ($plugin_slug, $edition)                  { return "https://download.neo-wp.com/" . get_zip_file_name_without_version($plugin_slug, $edition); }
function get_plugin_download_zip_file_url                 ($plugin_slug, $edition, $version)        { return "https://download.neo-wp.com/" . get_zip_file_name($plugin_slug, $edition, $version); }

function get_plugin_namespace_prefix                      ($plugin_slug, $edition)                  { return "Neo" . ucfirst(str_replace("-", "", preg_replace('/^neo-/i', "", $plugin_slug))) . ($edition === "store" ? "" : ucfirst($edition)) . "\\"; }
function get_bundle_id_lowercase                          ($plugin_slug, $edition)                  { return $plugin_slug . ($edition === "store" ? "" : ("_" . $edition)); }
function get_bundle_id_uppercase                          ($plugin_slug, $edition)                  { return strtoupper(str_replace("-", "_", get_bundle_id_lowercase($plugin_slug, $edition))); }
function get_manager_list_filename                        ($user_type)                              { return "_neo-manager-plugin-list" . ($user_type === "user" ? "" : ("-" . $user_type)) . ".json"; }
function get_manager_list_url                             ($user_type)                              { return "https://download.neo-wp.com/" . get_manager_list_filename($user_type); }

function is_alpha_update_version($version) { return str_contains($version, ".a"); }
function is_live_update_version($version)  { return str_contains($version, ".l"); }
function get_plugin_bundle_version_next($edition, $is_alpha, $is_live, $last_version = null, $timestamp_for_recursive_call = null) {
    $timestamp = $timestamp_for_recursive_call ?? time();
    $next_bundle_version = (\NeoRenameBeta\NeoGlobal\utc_date_string("Y", $timestamp) - 2000) . "." . \NeoRenameBeta\NeoGlobal\utc_date_string("n", $timestamp) . "." . \NeoRenameBeta\NeoGlobal\utc_date_string("j", $timestamp);
    if ($edition === "beta")  { $next_bundle_version .= ".b" . \NeoRenameBeta\NeoGlobal\utc_date_string("His", $timestamp); }
    if ($is_alpha)            { $next_bundle_version .= ".a" . \NeoRenameBeta\NeoGlobal\utc_date_string("His", $timestamp); }
    if ($is_live)             { $next_bundle_version .= ".l" . \NeoRenameBeta\NeoGlobal\utc_date_string("His", $timestamp); }
    if ($last_version !== null && !version_compare($next_bundle_version, $last_version, ">")) {
        return get_plugin_bundle_version_next($edition, $is_alpha, $is_live, $last_version, $timestamp + (1) * 24 * 60 * 60);
    }
    return $next_bundle_version;
}
function get_module_name($rel_path) {
    if (str_starts_with($rel_path, "/")) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid relative path: $rel_path - cannot start with /"); }
    return \NeoRenameBeta\NeoEntrypoint\_neo_entry_function_get_module_name($rel_path);
}
function get_module_namespace($rel_path) {
    if (str_starts_with($rel_path, "_global-"))                                 { return "NeoGlobal"; }
    else if ($rel_path === (basename(\NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path()))) { return "NeoEntrypoint"; }
    else if (str_starts_with($rel_path, "neo-"))                                { return "Neo" . ucfirst(str_replace("neo-", "", get_module_name($rel_path))); }
    else if ($rel_path === "index.php")               { return null; }
    else if ($rel_path === "live-update.php")         { return null; }
    return null;
}


function plugin_version_without_live_timestamp() { return preg_replace('/\.l\d+/', "", \NeoRenameBeta\NeoEntrypoint\plugin_version()); }
function plugin_path() { return dirname(\NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path()); }
function plugin_url() {
    if (!function_exists('\NeoRenameBeta\NeoGlobal\cachebust_and_get_plugin_url')) { return untrailingslashit(plugins_url("", \NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path())); }
    return \NeoRenameBeta\NeoGlobal\cachebust_and_get_plugin_url();
}
function plugin_basename_for_wp() {
    return plugin_basename(\NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path());
}
function plugin_modules() {
    $this_plugin_info = null; foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $p) { if ($p["slug"] === \NeoRenameBeta\NeoEntrypoint\plugin_slug() && $p["edition"] === \NeoRenameBeta\NeoEntrypoint\plugin_edition() && $p["version"] === \NeoRenameBeta\NeoEntrypoint\plugin_version()) { $this_plugin_info = $p; break; } }
    return array_keys($this_plugin_info["module_files"] ?? []);
}
function plugin_icon_url() {
    if (file_exists(plugin_path() . "/img/plugin-" . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . "-icon.svg")) { return plugin_url() . "/img/plugin-" . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . "-icon.svg"; }
    return plugin_url() . "/img/plugin-neo-universe-icon.svg";
}
function make_plugin_file_path_relative($abs_path) {
    $rel_path = preg_replace('#^' . preg_quote(WP_PLUGIN_DIR, '#') . '/[^/]+/#', "", $abs_path);
    if (str_starts_with($abs_path, "/var/www/neowp/neowp")) { $rel_path = ltrim(str_replace("/var/www/neowp/neowp", "", $abs_path), "/"); }
    if ($rel_path === $abs_path) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid absolute path: $abs_path - cannot be converted to relative path within plugin"); }
    return $rel_path;
}
function is_plugin_symlinked() { return \NeoRenameBeta\NeoEntrypoint\plugin_slug() === "neowp" && is_link(WP_PLUGIN_DIR . "/" . "neowp"); }
function cache_server_username_suffix() {
    
    $server_username = null;
    if (function_exists("posix_getuid") && function_exists("posix_getpwuid")) {
        $user_info = @posix_getpwuid(@posix_getuid());
        if (!empty($user_info["name"])) { $server_username = $user_info["name"]; }
    }

    return in_array($server_username, [null, "www-data"]) ? "" : "_" . $server_username;
}
