<?php
namespace NeoRenameBeta\NeoGlobal;























function cachebusted_assets_folder_prefix() { return "assets-"; }
function cachebusted_assets_folder_name() {
    static $cachebusted_assets_folder_name = null; if ($cachebusted_assets_folder_name !== null) { return $cachebusted_assets_folder_name; }
    if (\NeoRenameBeta\NeoEntrypoint\plugin_slug() === "neo-prod" && !empty(\NeoRenameBeta\NeoGlobal\array_filter_better(\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins(), fn ($p) => $p["edition"] === "dev"))) {
        
        $dirs = glob(\NeoRenameBeta\NeoGlobal\cache_path("cache-bust") . "/" . cachebusted_assets_folder_prefix() . "*"); usort($dirs, fn($a, $b) => strcmp(basename($b), basename($a))); if (!empty($dirs)) { $cachebusted_assets_folder_name = basename($dirs[0]); return $cachebusted_assets_folder_name; }
    }
    $cachebusted_assets_folder_name = cachebusted_assets_folder_prefix() . \NeoRenameBeta\NeoEntrypoint\plugin_version();
    if (\NeoRenameBeta\NeoEntrypoint\plugin_edition() === "dev") {
        
        $newest_modified_time = 0;
        foreach (\NeoRenameBeta\NeoGlobal\iterate_all_files(\NeoRenameBeta\NeoGlobal\plugin_path()) as $file_path) {
            $file_modified_time = filemtime($file_path);
            if ($file_modified_time > $newest_modified_time) { $newest_modified_time = $file_modified_time; }
        }
        $cachebusted_assets_folder_name .= "." . \NeoRenameBeta\NeoGlobal\utc_date_string("Y-m-d_H-i-s", $newest_modified_time);
    }
    [$color_theme, $interface_ok] = \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoPro\interface_get_color_theme_20250530')();
    if ($interface_ok && $color_theme !== "neo") { $cachebusted_assets_folder_name .= "-color-theme-$color_theme"; }
    return $cachebusted_assets_folder_name;
}


function cachebust_and_get_plugin_url() {
    try {
        \NeoRenameBeta\NeoGlobal\performance_checkpoint("cachebust start");
        
        if (\NeoRenameBeta\NeoGlobal\cache_path("cache-bust") === false) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Cache path not writable or could not be created!"); }
        
        $cachebusted_assets_folder_name = cachebusted_assets_folder_name();
        
        $new_cachebusted_assets_dir = \NeoRenameBeta\NeoGlobal\cache_path("cache-bust") . "/" . $cachebusted_assets_folder_name;
        $new_cachebusted_assets_dir_relative = "./" . $cachebusted_assets_folder_name;
        if (!file_exists($new_cachebusted_assets_dir)) {
            
            \NeoRenameBeta\NeoGlobal\synclock_dir(\NeoRenameBeta\NeoGlobal\cache_path("cache-bust"), function () use ($new_cachebusted_assets_dir, $new_cachebusted_assets_dir_relative) {
                
                \NeoRenameBeta\NeoGlobal\copy_all(\NeoRenameBeta\NeoGlobal\plugin_path(), $new_cachebusted_assets_dir, function ($path) { return pathinfo($path, PATHINFO_EXTENSION) !== "php"; });
                
                foreach (\NeoRenameBeta\NeoGlobal\iterate_all_files($new_cachebusted_assets_dir) as $file_path) {
                    file_put_contents($file_path, \NeoRenameBeta\NeoGlobal\transform_colors(file_get_contents($file_path), basename($file_path)));
                }

                $symlink_folder_names_referenced_in_custom_website_cache = [];
                $symlink_paths = \NeoRenameBeta\NeoGlobal\array_filter_better(glob(\NeoRenameBeta\NeoGlobal\cache_path("cache-bust") . "/*"), "is_link");
                $custom_website_cache_path = \NeoRenameBeta\NeoGlobal\cache_path() . "/custom-website-cache";
                if (file_exists($custom_website_cache_path) && !empty($symlink_paths)) {
                    
                    $symlink_folder_name_regex = "/" . implode("|", array_map(function ($part) { return preg_quote(basename($part), "/"); }, $symlink_paths)) . "/";
                    foreach (\NeoRenameBeta\NeoGlobal\iterate_all_files($custom_website_cache_path) as $custom_website_cache_file) {
                        $cache_html_contents = file_get_contents($custom_website_cache_file);
                        preg_match_all($symlink_folder_name_regex, $cache_html_contents, $matches);
                        $symlink_folder_names_referenced_in_custom_website_cache = array_merge($symlink_folder_names_referenced_in_custom_website_cache, $matches[0]);
                    }
                    $symlink_folder_names_referenced_in_custom_website_cache = \NeoRenameBeta\NeoGlobal\array_unique_better($symlink_folder_names_referenced_in_custom_website_cache);
                }

                foreach ($symlink_paths as $symlink_path) {
                    
                    unlink($symlink_path);
                    symlink($new_cachebusted_assets_dir_relative, $symlink_path);
                    
                    if (in_array(basename($symlink_path), $symlink_folder_names_referenced_in_custom_website_cache)) { continue; }
                    
                    if (preg_match("/^.*\.(\d+)-(\d+)-(\d+)_(\d+)-(\d+)-(\d+)/", basename($symlink_path), $matches)) {
                        $year=$matches[1]; $month=$matches[2]; $day=$matches[3]; $hour=$matches[4]; $minute=$matches[5]; $second=$matches[6];
                        $old_cached_assets_folder_timestamp = \NeoRenameBeta\NeoGlobal\timestamp_from_utc_date_string("$year-$month-$day $hour:$minute:$second");
                        if ($old_cached_assets_folder_timestamp >= time() - (2) * 24 * 60 * 60) { continue; }
                    }

                    unlink($symlink_path);
                }

                $non_trash_folders = \NeoRenameBeta\NeoGlobal\array_filter_better(glob(\NeoRenameBeta\NeoGlobal\cache_path("cache-bust") . "/" . cachebusted_assets_folder_prefix() . "*"), function ($path) { return is_dir($path) && !is_link($path) && !str_contains($path, "-trash-"); });
                foreach ($non_trash_folders as $old_cachebusted_asset_dir) {
                    if ($old_cachebusted_asset_dir === $new_cachebusted_assets_dir) { continue; }
                    $old_cachebusted_asset_dir_trash = $old_cachebusted_asset_dir . "-trash-" . \NeoRenameBeta\NeoGlobal\unique_planck_date();
                    rename($old_cachebusted_asset_dir, $old_cachebusted_asset_dir_trash);
                    symlink($new_cachebusted_assets_dir_relative, $old_cachebusted_asset_dir);
                }

                foreach (glob(\NeoRenameBeta\NeoGlobal\cache_path("cache-bust") . "/" . cachebusted_assets_folder_prefix() . "*-trash-*") as $old_cachebusted_asset_dir) {
                    \NeoRenameBeta\NeoGlobal\delete_all($old_cachebusted_asset_dir);
                }

                \NeoRenameBeta\NeoGlobal\flush_all_third_party_caches();
            });
        }

        return \NeoRenameBeta\NeoGlobal\cache_url("cache-bust") . "/" . $cachebusted_assets_folder_name;
    } catch (\Exception $e) {
        \NeoRenameBeta\NeoGlobal\global_warn("Could not cachebust assets. Using normal assets folder. Error: " . $e->getMessage());
        return rtrim(plugins_url("", \NeoRenameBeta\NeoEntrypoint\plugin_entry_file_path(), "/"));
    } finally {
        \NeoRenameBeta\NeoGlobal\performance_checkpoint("cachebust end");
    }
}
