<?php
namespace NeoRenameBeta\NeoGlobal;


function cache_path($subdir = null) {
    
    static $cache_path_cache = [];
    if (isset($cache_path_cache[$subdir]) && !file_exists($cache_path_cache[$subdir])) { unset($cache_path_cache[$subdir]); }
    if (isset($cache_path_cache[$subdir])) { return $cache_path_cache[$subdir]; }
    
    if ($subdir === "neo-log") {
        $existing_subdir = glob(cache_path() . "/$subdir-*", GLOB_ONLYDIR)[0] ?? null;
        if ($existing_subdir) { return cache_path(basename($existing_subdir)); }
        return cache_path($subdir . "-" . bin2hex(random_bytes(8)));
    }

    $cache_path = WP_CONTENT_DIR . "/cache/" . \NeoRenameBeta\NeoGlobal\get_plugin_cache_folder_name(\NeoRenameBeta\NeoEntrypoint\plugin_slug(), \NeoRenameBeta\NeoEntrypoint\plugin_edition());
    
    \NeoRenameBeta\NeoGlobal\suppress_log(true); try {
        
        \NeoRenameBeta\NeoGlobal\mkdir_better($cache_path);
        
        $cache_path_owner   = @fileowner($cache_path) ?: "www-data";                 $cache_path_group   = @filegroup($cache_path) ?: "www-data";
        $uploads_path_owner = @fileowner(WP_CONTENT_DIR . "/uploads") ?: "www-data"; $uploads_path_group = @filegroup(WP_CONTENT_DIR . "/uploads") ?: "www-data";
        if ($cache_path_owner === 0 && ($cache_path_owner !== $uploads_path_owner || $cache_path_group !== $uploads_path_group)) {
            chown($cache_path, $uploads_path_owner);
            chgrp($cache_path, $uploads_path_group);
        }

        return \NeoRenameBeta\NeoGlobal\synclock_dir($cache_path, function() use (&$cache_path_cache, &$cache_path, &$subdir) {
            
            $cleanup_cache = false;
            $version_file = $cache_path . "/.version";
            if (file_exists($version_file) && \NeoRenameBeta\NeoEntrypoint\plugin_version() !== file_get_contents($version_file)) {
                $cleanup_cache = true;
                file_put_contents($version_file, \NeoRenameBeta\NeoEntrypoint\plugin_version());
            }

            if (\NeoRenameBeta\NeoGlobal\is_live_update_version(\NeoRenameBeta\NeoEntrypoint\plugin_version())) { $cleanup_cache = false; }
            
            if (count(glob($cache_path . "/custom-*")) > 0) { $cleanup_cache = false; }
            
            if ($cleanup_cache) {
                
                $exceptions = [
                    ".version",
                    ".lock*",
                    "cache-bust",
                    "neo-log",
                ];
                $items = \NeoRenameBeta\NeoGlobal\array_filter_better(\NeoRenameBeta\NeoGlobal\array_diff_better(array_merge(glob("$cache_path/*", GLOB_MARK), glob("$cache_path/.*", GLOB_MARK)), [".", ".."]), function ($item) use ($exceptions) { foreach ($exceptions as $ex) { if (fnmatch($ex, basename($item))) return false; } return true; });
                foreach ($items as $item) { is_dir($item) ? \NeoRenameBeta\NeoGlobal\delete_all($item) : unlink($item); }
            }

            $cache_hash_path = $cache_path . "/cache-hash.json";
            $is_cache_hash_valid = function () use ($cache_hash_path) { try { $cache_hash_contents = \NeoRenameBeta\NeoGlobal\json_decode_better(file_get_contents($cache_hash_path) ?: "[]"); return $cache_hash_contents["cache_hash"] === $cache_hash_contents["plugin_hash"]; } catch (\Throwable $e) { \NeoRenameBeta\NeoGlobal\global_warn("Invalid cache hash: " . $e->message); return false; } };
            if (!file_exists($cache_hash_path) || filemtime($cache_hash_path) < time() - (7) * 24 * 60 * 60 || !$is_cache_hash_valid()) {
                $cache_hash = "";
                
                $files = iterator_to_array(\NeoRenameBeta\NeoGlobal\iterate_all_files(\NeoRenameBeta\NeoGlobal\plugin_path()));
                usort($files, function ($a, $b) { return strcmp($a, $b); });
                foreach ($files as $file) {
                    if (!str_ends_with($file, "." . pathinfo(__FILE__, PATHINFO_EXTENSION))) { continue; }
                    if (str_ends_with($file, "/neo-pro-activate-license" . "." . pathinfo(__FILE__, PATHINFO_EXTENSION))) { continue; }
                    $cache_hash .= md5(file_get_contents($file));
                    
                }
                $cache_hash = md5($cache_hash);
                $plugin_hash_path       = \NeoRenameBeta\NeoGlobal\plugin_path() . "/" . "plugin-hash.txt";
                
                file_put_contents($cache_hash_path, \NeoRenameBeta\NeoGlobal\json_encode_better(["cache_hash" => $cache_hash, "plugin_hash" => file_exists($plugin_hash_path) ? file_get_contents($plugin_hash_path) : null]));
                
                
            }

            if (!file_exists($cache_path . "/index.php")) { file_put_contents($cache_path . "/index.php", "<?php\n// Silence is golden.\n"); }
            
            $cache_path_with_subdir = $cache_path . ($subdir ? ("/" . $subdir) : "");
            \NeoRenameBeta\NeoGlobal\mkdir_better($cache_path_with_subdir);
            
            $cache_path_cache[$subdir] = $cache_path_with_subdir;
            
            return $cache_path_with_subdir;
        });
    } finally { \NeoRenameBeta\NeoGlobal\suppress_log(false); }
}


function cache_url($subdir) {
    return content_url() . "/cache/" . \NeoRenameBeta\NeoGlobal\get_plugin_cache_folder_name(\NeoRenameBeta\NeoEntrypoint\plugin_slug(), \NeoRenameBeta\NeoEntrypoint\plugin_edition()) . "/" . $subdir;
}
