<?php
namespace NeoRenameBeta\NeoGlobal;



function clear_cache() {

    $cache_path = \NeoRenameBeta\NeoGlobal\cache_path();
    $delete_cache_filter = null;
    $exclude_cache_folders = ["custom-gpt"];
    if (!empty(\NeoRenameBeta\NeoGlobal\array_filter_better($exclude_cache_folders, fn ($folder) => file_exists("$cache_path/$folder")))) {
        $delete_cache_filter = fn ($path) => !array_reduce($exclude_cache_folders, fn ($carry, $folder) => $carry || str_contains($path, $folder), false);
    }
    $folder_delete_success = \NeoRenameBeta\NeoGlobal\delete_all(\NeoRenameBeta\NeoGlobal\cache_path(), $delete_cache_filter);
    if (!$folder_delete_success) { throw new \NeoRenameBeta\NeoGlobal\GlobalException(\NeoRenameBeta\NeoGlobal\neo__("Server error (file system)", "Serverfehler (Dateisystem)")); }
    
    [$elementor_inline_svg_delete_success, $interface_ok] = \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoDraw\interface_draw_pagebuilder_elementor_inline_svg_db_clear_20250302')();
    if ($interface_ok && !$elementor_inline_svg_delete_success) { throw new \NeoRenameBeta\NeoGlobal\GlobalException(\NeoRenameBeta\NeoGlobal\neo__("Server error (database)", "Serverfehler (Datenbank)")); }
    
    \NeoRenameBeta\NeoGlobal\flush_all_third_party_caches();
}
