<?php
namespace NeoRenameBeta\NeoGlobal;





function get_color_theme_replacements($filename = null, $theme = "auto") {
    if ($theme === "auto") {
        [$theme, $interface_ok] = \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoPro\interface_get_color_theme_20250530')();
        if (!$interface_ok) { $theme = "neo"; }
    }
    if ($theme === "neo") {
        
        $color_map = [
            "#ff00ff" => "color(display-p3 1 0 1)",
            "#00ff00" => "color(display-p3 0 1 0)",
        ];

        if ($filename === "neo-library-button-rename-icon.svg")               { $color_map["#00ffff"] = "color(display-p3 0 1 1)"; }
        if ($filename === "neo-library-button-duplicate-icon.svg")            { $color_map["#ffff00"] = "color(display-p3 1 1 0)"; }
        if ($filename === "neo-library-button-duplicate-to-neodraw-icon.svg") { $color_map["#ffff00"] = "color(display-p3 1 1 0)"; }
        
        return $color_map;
    } else if ($theme === "pro") {
        




























return get_color_theme_replacements($filename, theme: "neo");

    } else {
        return [];
    }
}


function transform_colors($string, $filename = null, $theme = "auto") {
    $replacements = get_color_theme_replacements($filename, theme: $theme);
    return str_ireplace(array_keys($replacements), array_values($replacements), $string);
}
