<?php
namespace NeoRenameBeta\NeoGlobal;


function get_domain_settings() {
    
    static $domain_settings_cache = null; if ($domain_settings_cache !== null) { return $domain_settings_cache; }
    
    try {

        $domain = $_SERVER["HTTP_HOST"] ?? "";
        $domain = preg_replace("/[^a-zA-Z0-9-\.]/", "", $domain);
        if (file_exists("/var/www/download.$domain/_domain-settings.json")) {
            $all_domain_settings = file_get_contents("/var/www/download.$domain/_domain-settings.json");
        } else {
            $all_domain_settings = \NeoRenameBeta\NeoGlobal\curl_request("https://download.neo-wp.com/_domain-settings.json", "GET", null, 2);
        }

        $all_domain_settings = \NeoRenameBeta\NeoGlobal\json_decode_better($all_domain_settings);
        $domain_hash = hash("sha256", $_SERVER["HTTP_HOST"] ?? "");
        $domain_settings_cache = $all_domain_settings[$domain_hash] ?? [];
        return $domain_settings_cache;
    } catch (\Exception $e) {
        \NeoRenameBeta\NeoGlobal\global_warn("Could not load domain settings from NeoWP Prod-Server: " . $e->getMessage());
        $domain_settings_cache = [];
        return [];
    }
}
