<?php
namespace NeoRenameBeta\NeoGlobal;




function freemius_product_id() {
    $hardcoded_value = "12083";
    if (isset($GLOBALS["custom_license_settings"]) && $GLOBALS["custom_license_settings"]["freemius_product_id"] !== $hardcoded_value) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Freemius product ID mismatch: " . $GLOBALS["custom_license_settings"]["freemius_product_id"] . " != " . $hardcoded_value . ". Update hardcoded value in _global-freemius.php."); }
    return $hardcoded_value;
}
function freemius_slug_free() { return "neo-media"; }
function freemius_slug_pro()  { return "neo-media-pro"; }
function freemius_product_public_key() {
    $hardcoded_value = "pk_01093f748756a4db76d7003ade4ab";
    if (isset($GLOBALS["custom_license_settings"]) && $GLOBALS["custom_license_settings"]["freemius_product_public_key"] !== $hardcoded_value) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Freemius public key mismatch: " . $GLOBALS["custom_license_settings"]["freemius_product_public_key"] . " != " . $hardcoded_value . ". Update hardcoded value in _global-freemius.php."); }
    return $hardcoded_value;
}




function freemius_debug_mode_activate()   { update_option("neo-global-freemius-debug-secret-key", $GLOBALS["custom_license_settings"]["freemius_secret_key"]); }
function freemius_debug_mode_deactivate() { delete_option("neo-global-freemius-debug-secret-key"); }
function freemius_debug_mode() {
    $freemius_debug_secret_key = get_option("neo-global-freemius-debug-secret-key");
    if (!$freemius_debug_secret_key) { return; }
    $is_custom_cache_self_call = ($_SERVER["HTTP_USER_AGENT"] ?? "") === "CustomCache";
    if ($is_custom_cache_self_call) { return false; }
    
    $ensure_definition = function ($name, $value) {
        if (defined($name) && constant($name) !== $value) { trigger_error("Freemius Debug variable " . $name . " is already defined with a different value: " . constant($name) . " != " . $value); }
        else if (defined($name) && constant($name) === $value) { return; }
        else { define($name, $value); }
    };
    $ensure_definition("WP_FS__DEV_MODE", true);
    $ensure_definition("WP_FS__SKIP_EMAIL_ACTIVATION", true);
    $ensure_definition("WP_FS__" . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . "_SECRET_KEY",      $freemius_debug_secret_key);
    $ensure_definition("WP_FS__" . \NeoRenameBeta\NeoEntrypoint\plugin_slug() . "-free_SECRET_KEY", $freemius_debug_secret_key);
    add_action("neo_init", function () {
        
        \NeoRenameBeta\NeoGlobal\add_action_hook("wp_enqueue_scripts", "admin_enqueue_scripts", function () {
            ?><script type="module">
                import { observeOnce } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global--observer.js";
                
                observeOnce(".debug-bar-php-list", (debugElem) => { 
                    (document.getElementById("wpbody-content") || document.body).prepend(debugElem); 
                });
            </script><?php
        });
    });
}


(function () {
    if (defined("WP_CLI")) { return; }
    freemius_debug_mode();
    $freemius_start_php = dirname(__FILE__) . "/" . "neo-freemius-" . "thirdparty" . "/" . "start.php"; if (!file_exists($freemius_start_php)) { return; } (fn () => require_once($freemius_start_php))();
    
    $neo_fs = fs_dynamic_init([
            "id"                  => freemius_product_id(),
            "slug"                => freemius_slug_free(),
            "premium_slug"        => freemius_slug_pro(),
            "type"                => "plugin",
            "public_key"          => freemius_product_public_key(),
            "premium_suffix"      => "Pro",
            "has_premium_version" => false, "is_org_compliant" => true,
            "has_addons"          => false,
            "has_paid_plans"      => true,
            "is_premium"      => !(\NeoRenameBeta\NeoEntrypoint\plugin_slug() === "neo-media"),
            "is_premium_only" => \NeoRenameBeta\NeoEntrypoint\plugin_slug() === "neo-media",
            "trial"               => [
                "days"               => 14,
                "is_require_payment" => true,
            ],
            "menu" => [
                "slug"    => \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug(),
                "contact" => true,
                "support" => false,
            ],

            "secret_key" => isset($GLOBALS["custom_freemius_secret_key"]) ? $GLOBALS["custom_freemius_secret_key"] : null,
            
            "is_live" => get_option("neo-global-freemius-debug-secret-key") ? true : null,
        ]
    );
    do_action("neo_fs_loaded");
    $neo_fs->add_filter("pricing/discounts_model", function ($model) { return "relative"; });
    $GLOBALS["neo_global_freemius_NEO_RENAME_BETA"] = $neo_fs;
})();


function freemius_instance() { return $GLOBALS["neo_global_freemius_NEO_RENAME_BETA"] ?? null; }


function get_freemius_license() {
    $license_id = freemius_instance()->get_account_option("sites")[freemius_slug_free()]->license_id ?? null;
    $all_licenses = freemius_instance()->get_account_option("all_licenses")[freemius_product_id()] ?? [];
    $license = null; foreach ($all_licenses as $l) { if ($l->id === $license_id) { $license = $l; break; } }
    return $license;
}
