<?php
namespace NeoRenameBeta\NeoGlobal;



$GLOBALS["neo_global_frontend_image_hook_callbacks_NEO_RENAME_BETA"] = [];


function frontend_image_hook_register_callback($callback) {
    $GLOBALS["neo_global_frontend_image_hook_callbacks_NEO_RENAME_BETA"][] = $callback;
}


$GLOBALS["neo_global_frontend_image_hook_image_cache_NEO_RENAME_BETA"] = [];
\NeoRenameBeta\NeoGlobal\add_filter_hook(
    "the_content",
    "bricks/frontend/render_data",
    function ($html) {
        if ($html === "") { return $html; }
        
        $process_image = function ($img_attributes) {
            
            $cache_hash = md5(\NeoRenameBeta\NeoGlobal\json_encode_better($img_attributes)); if (isset($GLOBALS["neo_global_frontend_image_hook_image_cache_NEO_RENAME_BETA"][$cache_hash])) { return $GLOBALS["neo_global_frontend_image_hook_image_cache_NEO_RENAME_BETA"][$cache_hash]; }
            
            $set_changes = [];
            $get_attr = function ($key) use (&$img_attributes) { return $img_attributes[$key] ?? null; };
            $set_attr = function ($key, $value) use (&$img_attributes, &$set_changes) { $set_changes[$key] = $value; if ($value === null) { unset($img_attributes[$key]); return; } else { $img_attributes[$key] = $value; } };
            
            if (!\NeoRenameBeta\NeoGlobal\is_url_internal($get_attr("src"))) { return ["new_attributes" => $img_attributes, "set_changes" => []]; }
            
            $image_file_path = untrailingslashit(ABSPATH) . \NeoRenameBeta\NeoGlobal\get_url_path($get_attr("src"));
            
            if (!file_exists($image_file_path)) { return ["new_attributes" => $img_attributes, "set_changes" => []]; }
            
            foreach ($GLOBALS["neo_global_frontend_image_hook_callbacks_NEO_RENAME_BETA"] as $callback) {
                try {
                    $callback($get_attr, $set_attr, $image_file_path) ?? $img_attributes;
                } catch (\Exception $e) { \NeoRenameBeta\NeoGlobal\global_warn($e->getMessage() . " - Failed to process image: " . $get_attr("src")); }
            }

            $GLOBALS["neo_global_frontend_image_hook_image_cache_NEO_RENAME_BETA"][$cache_hash] = ["new_attributes" => $img_attributes, "set_changes" => $set_changes];
            return $GLOBALS["neo_global_frontend_image_hook_image_cache_NEO_RENAME_BETA"][$cache_hash];
        };


        
        $img_url_regex_raw = "https?:\/\/(www\.)?[-a-z0-9@:%._\+~#=]{1,256}\.[a-z0-9()]{1,6}\b([-a-z0-9()@:%_\+.~\/=]*)\.(?:jpg|jpeg|jfif|webp|avif|png|gif|bmp|tiff|heic|heif|svg|ico)(?![a-z0-9\.])(\?[-a-z0-9()@:%_\+.~#&\/=]*)?";
        $img_tag_regex_raw = "<img[^>]*" . $img_url_regex_raw . "[^>]*>";
        $img_tag_or_url_regex = "/(?<img_tag>$img_tag_regex_raw)|(?<img_url>$img_url_regex_raw)/i";
        return preg_replace_callback($img_tag_or_url_regex, function ($matches) use ($process_image, $img_url_regex_raw) {
            if (!empty($matches["img_tag"])) {
                $img_tag = $matches["img_tag"];
                
                if (str_contains($img_tag, "data-neo-processed")) { return $img_tag; }
                
                $attr_regex_pattern = '/(?<key>[a-zA-Z0-9_\-:]+)(?<equals>\s*=\s*)(?:"(?<value1>[^"]*)"|\'(?<value2>[^\']*)\'|(?<value3>[^\s"\']+))/';
                
                $attributes = [];
                if (preg_match_all($attr_regex_pattern, $img_tag, $matches, PREG_SET_ORDER)) {
                    foreach ($matches as $match) {
                        $attr_key   = $match["key"];
                        $attr_value = $match["value1"] ?? $match["value2"] ?? $match["value3"] ?? null;
                        if (isset($attributes[$attr_key])) { \NeoRenameBeta\NeoGlobal\global_warn("Duplicate attribute in image tag: " . $attr_key . " in " . $img_tag . ". It was deduplicated."); }
                        $attributes[$attr_key] = $attr_value;
                    }
                }

                $set_changes_by_attribute_key = [];
                $attributes_before = $attributes;
                foreach ($attributes as $attr_key => $attr_value) {
                    if ($attr_value === null) { continue; }
                    $attributes[$attr_key] = preg_replace_callback("/$img_url_regex_raw/i", function ($match) use (&$attributes_before, &$process_image, &$attr_key, &$set_changes_by_attribute_key) {
                        
                        $img_url = $match[0];
                        $fake_attributes = $attributes_before; $fake_attributes["src"] = $img_url;
                        ["new_attributes" => $fake_attributes, "set_changes" => $set_changes] = $process_image($fake_attributes);
                        $result = $fake_attributes["src"];
                        unset($set_changes["src"]);
                        $set_changes_by_attribute_key[$attr_key] ??= []; $set_changes_by_attribute_key[$attr_key][] = $set_changes;
                        return $result;
                    }, $attr_value);
                }

                $set_changes_for_src = $set_changes_by_attribute_key["data-src"][0] ?? $set_changes_by_attribute_key["src"][0] ?? [];
                foreach ($set_changes_for_src as $attr_key => $attr_value) { if ($attr_value === null) { unset($attributes[$attr_key]); } else { $attributes[$attr_key] = $attr_value; } }
                
                $attributes["data-neo-processed"] = "true";
                
                $additional_attributes_string = ""; foreach ($attributes as $key => $value) { if (in_array($key, array_keys($attributes_before))) { continue; } $additional_attributes_string .= ' ' . $key . ($value === null ? "" : ('="' . htmlspecialchars($value, ENT_QUOTES) . '"')); }
                $new_img_tag = preg_replace('/\s*\/?\s*>$/', (!empty($additional_attributes_string) ? " " : "") . $additional_attributes_string . "$0", $img_tag);
                
                $new_img_tag = preg_replace_callback($attr_regex_pattern, function ($match) use ($attributes) {
                    $key = $match["key"];
                    if (!isset($attributes[$key])) { return ""; }
                    $value = $attributes[$key];
                    $quote_type = isset($match["value1"]) ? '"' : (isset($match["value2"]) ? "'" : "");
                    if ($quote_type !== "" && str_contains($value, $quote_type)) { $value = preg_replace('/(?<!\\\\)' . $quote_type . '/', '\\' . $quote_type, $value); }
                    if ($value === null) { return $key; }
                    return $key . $match["equals"] . $quote_type . $value . $quote_type;
                }, $new_img_tag);
                
                return $new_img_tag;
            } else {
                
                $img_url = $matches["img_url"];
                if (str_contains($img_url, "neo-processed=true")) { return $img_url; }
                
                $img_url = $process_image(["src" => $img_url])["new_attributes"]["src"];
                
                $img_url = add_query_arg("neo-processed", "true", $img_url);
                return $img_url;
            }
        }, $html);
    }
);
