(() => { 
const NeoCard = class extends HTMLElement {
  constructor() {
    super();
    
    this.attachShadow({ mode: "open" });
    this.shadowRoot.innerHTML = `
      <style>
        /* Stil für die Menükarte */
        :host {
          display: flex;
          width: fit-content;
          max-width: 100%;
          padding: 30px 40px;
          box-sizing: border-box;
          box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
          background-color: white;
          border-radius: 20px;
          overflow: hidden;
        }
      </style>
      <slot></slot>
    `;
  }
}


if (!document.currentScript.hasAttribute("data-web-component-name")) { 
  throw new Error("You have to provide a 'data-web-component-name' attribute for the script tag!"); 
}
customElements.define(document.currentScript.getAttribute("data-web-component-name"), NeoCard);
})(); 
