(() => {  
  class NeoManagerCard extends HTMLElement {
    static get observedAttributes() { return ['plugin-name','slogan','icon-url','icon-animated-url','coming-soon','info-items']; } 
    constructor() { super(); this.attachShadow({ mode: 'open' }); this._render(); } 
    attributeChangedCallback(name, oldValue, newValue) { if (oldValue !== newValue) this._render(); } 
    _render() { 
      const name        = this.getAttribute('plugin-name')        || ''; 
      const slogan      = this.getAttribute('slogan')             || ''; 
      const iconUrl     = this.getAttribute('icon-url')           || ''; 
      const iconAnimUrl = this.getAttribute('icon-animated-url')  || iconUrl; 
      const comingSoon  = this.hasAttribute('coming-soon'); 
      let infoItems     = []; 
      try { infoItems = JSON.parse(this.getAttribute('info-items') || '[]'); } catch (e) { infoItems = []; } 
      const infoHtml = infoItems.length > 0 ? infoItems.map(item => `<a href="${item.url ?? 'javascript:void()'}" target="_blank" rel="noopener">${item.label}</a>`).join('&nbsp;·&nbsp;'): ''; 

      this.shadowRoot.innerHTML = `
        <style>
          :host { position: relative; display: flex; width: 100%; box-sizing: border-box; background: white; border-radius: 20px; box-shadow: 0 0 10px rgba(0,0,0,0.1); overflow: hidden; gap: 40px; padding: 30px 40px; align-items: center; font-family: sans-serif; } /* Flexbox-Layout für die Karte */
          .cell-icon { position: relative; width: 75px; height: 75px; } /* Container für das Icon */
          .cell-icon img { width: 100%; height: 100%; object-fit: contain; display: block; } /* Icon-Bilder */
          .icon-animated { position: absolute; top: 0; left: 0; opacity: 0; } /* Animiertes Icon standardmäßig versteckt */
          :host(:hover) .icon-static { opacity: 0; transition: opacity 0.5s; } /* Animiertes Icon anzeigen, wenn Maus über Karte */
          :host(:hover) .icon-animated { opacity: 1; transition: opacity 0.5s; } /* Animiertes Icon anzeigen, wenn Maus über Karte */
          .cell-info { flex-grow: 1; display: flex; flex-direction: column; gap: 5px; } /* Container für den Titel und Slogan */
          .cell-info .title { margin: 0; margin-bottom: 0.1em; font-size: 1.8em; font-weight: bold; color: #202020; } /* Titel */
          .cell-info .slogan { margin: 0; font-size: 1.2em; color: #404040; } /* Slogan */
          .cell-info .info-items a { font-size: 1em; text-decoration: none; color: #2271b1; } /* Info-Items Links */
          .cells-right { display: flex; flex-direction: column; align-items: flex-end; gap: 20px; } /* Container für die Steuerungselemente */
          .banner { background-color: #C2255C; color: white; position: absolute; bottom: 0; right: 0; font-size: 1em; font-weight: bold; padding: 0.2em 10em; cursor: default; transform: translate(-3em,-3em) translate(50%,50%) rotate(-45deg); transform-origin: center; } /* Banner für Coming Soon */
        </style>

        <div class="cell-icon">
          <img class="icon-static" src="${iconUrl}" alt="${name}">
          <img class="icon-animated" src="${iconAnimUrl}" alt="${name}">
        </div>

        <div class="cell-info">
          <h2 class="title">${name}</h2>
          <p class="slogan">${slogan}</p>
          ${infoHtml ? `<div class="info-items">${infoHtml}</div>` : ''}
        </div>

        <div class="cells-right">
          <slot name="controls"></slot>
          <slot name="toggle"></slot>
        </div>

        ${comingSoon ? `<div class="banner">Coming Soon</div>` : ''}
      `;
    }
  }

  
  const scriptTag = document.currentScript; 
  const tagName   = scriptTag.getAttribute('data-web-component-name'); 
  if (!tagName) { throw new Error("You must add a 'data-web-component-name' attribute to the <script> tag!"); } 
  customElements.define(tagName, NeoManagerCard); 
})();
