

(() => { 
const crownUrl  = document.currentScript.getAttribute("data-crown-url"); 
const buyUrl    = document.currentScript.getAttribute("data-buy-url");   
const titleText = document.currentScript.getAttribute("data-title-text") || "Pro"; 
if (!(crownUrl && buyUrl && titleText)) { throw new Error("Pro Crown: You have to provide all attributes for the script tag! To ensure this, don't manually embed this web component but use \\NeoGlobal\\embed_pro_crown_web_component()"); } 
const NeoProCrown = class extends HTMLElement {
  constructor() {
    super();
    
    this.attachShadow({ mode: "open" });
    this.shadowRoot.innerHTML = `
      <style>
        :host { display: inline-block; line-height: 1; } /* Krone inline anzeigen */
        a:hover { filter: brightness(1.1); } /* Krone bei Hover aufhellen */
        a { display: inline-block; text-decoration: none; line-height: 0; } /* Link um die Krone */
        img { width: 24px; height: 24px; } /* Größe der Krone */
      </style>
      <a href="${buyUrl}" target="_blank" rel="noopener" title="${titleText}"> <!-- Link zur Kaufseite -->
        <img src="${crownUrl}" alt="Pro"> <!-- Krone-Bild -->
      </a>
    `;
  }
}


if (!document.currentScript.hasAttribute("data-web-component-name")) { 
  throw new Error("You have to provide a 'data-web-component-name' attribute for the script tag!"); 
}
customElements.define(document.currentScript.getAttribute("data-web-component-name"), NeoProCrown);
})(); 
