<?php
namespace NeoRenameBeta\NeoGlobal;




$GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"] = null;
function disallow_enqueue($reason_string, $callback) {
    try {
        $GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"] = $reason_string;
        $callback();
    } finally {
        $GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"] = null;
    }
}



function enqueue_css($relative_path) {
    if ($GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"] !== null) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Enqueueing CSS files is disallowed in this section of code: " . $GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"]); }
    wp_enqueue_style(
        "neo-" . str_replace(["/", "."], ["-", "-"], $relative_path),
        \NeoRenameBeta\NeoGlobal\plugin_url() . "/" . $relative_path,
        [],
        null,
    );
}


function enqueue_js($relative_path, $js_variable_name=null, $js_variable_data=null, $dependencies=[]) {
    if ($GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"] !== null) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Enqueueing CSS files is disallowed in this section of code: " . $GLOBALS["neo_global_enqueue_disallowed_NEO_RENAME_BETA"]); }
    
    
    $add_type_module = count($dependencies) == 0;
    $script_handle = "neo-NEO_RENAME_BETA-" . ($add_type_module ? "module-" : "") . str_replace(["/", "."], ["-", "-"], $relative_path);
    wp_enqueue_script(
        $script_handle,
        \NeoRenameBeta\NeoGlobal\plugin_url() . "/" . $relative_path,
        $dependencies,
        null,
    );
    if ($js_variable_name != null && $js_variable_data != null) {
        wp_localize_script(
            $script_handle,
            $js_variable_name,
            $js_variable_data
        );
    }
}


\NeoRenameBeta\NeoGlobal\add_filter_hook("script_loader_tag", function ($tag, $handle, $src) {
    if (!str_starts_with($handle, "neo-NEO_RENAME_BETA-")) { return $tag; }
    
    $script_var_name = "neo_" . str_replace(".", "", str_replace("-", "_", $handle)) . "_script";
    $tag = "<script>" .
            "const " . $script_var_name . ' = document.createElement("script");' .
            (str_starts_with($handle, "neo-NEO_RENAME_BETA-module") ? ($script_var_name . '.type = "module";') : "") .
            $script_var_name . '.src = "' . esc_url($src) . '";' .
            "document.head.appendChild(" . $script_var_name . ");" .
            "</script>";
    return $tag;
});
