<?php
namespace NeoRenameBeta\NeoConsolegreeting;

\NeoRenameBeta\NeoGlobal\add_action_hook("init", function() {
    if (!str_starts_with(get_locale(), "de")) { return; }
    if (!current_user_can("administrator")) { return; }
    if (!(get_option("neo-consolegreeting-hide", "1") === "1")) { return; }
    
    \NeoRenameBeta\NeoGlobal\add_action_hook("wp_enqueue_scripts", "admin_enqueue_scripts", function () {
        \NeoRenameBeta\NeoGlobal\enqueue_js("neo-consolegreeting.js", "neoGlobalConsoleGreetingHint", [
            "suppressPageUrl" => \NeoRenameBeta\NeoGlobal\get_backend_page_url("neo-consolegreeting-hide"),
        ]);
    });
    \NeoRenameBeta\NeoGlobal\register_backend_page("neo-consolegreeting-hide", function () {
        update_option("neo-consolegreeting-hide", "0");
        ?><html style="height:100%;">
            <head><title><?php echo \NeoRenameBeta\NeoGlobal\neo__("Success!", "Erfolg!") ?></title></head>
            <body style="height:100%;display:flex;flex-direction:column;justify-content:center;align-items:center;background-color:black;font-family:sans-serif;margin:0;">
                <div style="color: <?php echo \NeoRenameBeta\NeoGlobal\transform_colors("#00ff00") ?>;font-size:24px;"><?php echo \NeoRenameBeta\NeoGlobal\neo__("The message won't be shown again.", "Die Nachricht wird nicht mehr angezeigt.") ?></div>
                <a href="<?php echo admin_url() ?>" style="color: #00ffff;"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Back", "Zurück") ?></a>
            </body>
        </html><?php
    });
});
