<?php
namespace NeoRenameBeta\NeoDemocontent;




function import_demo_content() {
    $demo_content_provider_hostname = "neo-wp.com";
    if ($demo_content_provider_hostname === $_SERVER["HTTP_HOST"]) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Should not import demo-content on prod! It will delete the demo content!"); }
    global $wpdb;
    $imported_items = [];
    $cache_dir = \NeoRenameBeta\NeoGlobal\cache_path("neo-democontentprovider"); if (!is_dir($cache_dir) && !wp_mkdir_p($cache_dir)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Unable to create cache dir " . $cache_dir); }
    $zip_path = $cache_dir . "/import_" . time() . "_" . bin2hex(random_bytes(4)) . ".zip";
    try {
        
        $response = \NeoRenameBeta\NeoGlobal\curl_request("https://$demo_content_provider_hostname/wp-json/neo/demo-content", method: "GET", data: null, timeout: 60);
        file_put_contents($zip_path, $response);
        
        
        $post_ids = $wpdb->get_col("SELECT ID FROM {$wpdb->posts} WHERE post_name LIKE 'demo-%' OR post_name LIKE 'plugin-neo-%-icon'");
        foreach ($post_ids as $post_id) {
            $file = get_attached_file($post_id);
            if ($file && file_exists($file)) { unlink($file); }
            $wpdb->delete($wpdb->posts,    ["ID"      => $post_id]);
            $wpdb->delete($wpdb->postmeta, ["post_id" => $post_id]);
        }

        \NeoRenameBeta\NeoGlobal\delete_all(\NeoRenameBeta\NeoGlobal\cache_path("neo-optimize"));
        
        $zip = new \ZipArchive(); if ($zip->open($zip_path) !== true) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Unable to open downloaded zip"); }
        $upload_dir = wp_upload_dir(); $upload_base = $upload_dir["basedir"]; if (!is_dir($upload_base)) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Uploads dir missing " . $upload_base); }
        for ($i = 0, $count = $zip->numFiles; $i < $count; $i++) {
            $entry_name = $zip->getNameIndex($i);
            $content = $zip->getFromIndex($i);
            if (str_ends_with($entry_name, ".sql")) {
                $filename = basename($entry_name);
                $slug = sanitize_title(pathinfo($filename, PATHINFO_FILENAME));
                $lines = preg_split("/;\s*\n/", $content);
                foreach ($lines as $sql) {
                    $sql_trim = trim($sql);
                    if ($sql_trim === "") { continue; }
                    try { $success = $wpdb->query($sql_trim); if (!$success) { throw new \NeoRenameBeta\NeoGlobal\GlobalException("Failed to SQL-import"); } }
                    catch (\Throwable $e) { \NeoRenameBeta\NeoGlobal\global_log(["event" => "demo_import_sql_error", "error" => $e->getMessage(), "query" => $sql_trim]); }
                }
                $imported_items[] = ["filename" => $filename, "slug" => $slug];
            } else {
                $dest_path = $upload_base . "/" . basename($entry_name); file_put_contents($dest_path, $content);
                $filename = basename($entry_name);
                $slug = sanitize_title(pathinfo($filename, PATHINFO_FILENAME));
                $imported_items[] = ["filename" => $filename, "slug" => $slug];
            }
        }
        $zip->close();
    } finally { if (file_exists($zip_path)) { unlink($zip_path); } }
    return $imported_items;
}



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/demo-content-import", "POST", "admin", function ($get_param) {
    return import_demo_content();
});


\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {
    if (\NeoRenameBeta\NeoGlobal\is_playground()) { return; }
    $menu_render_callback = function () {
        ?><div>
            <p><?php echo \NeoRenameBeta\NeoGlobal\neo__("Import demo content from the neoWP website to this instance.", "Demo-Inhalte von der neoWP-Website in diese Instanz importieren."); ?></p>
            <button class="neo-democontent-button button button-primary">
                <?php echo \NeoRenameBeta\NeoGlobal\neo__("Import demo content", "Demo-Inhalte importieren"); ?>
            </button>
            <div class="neo-democontent-results"></div>
        </div>
        <script type="module">
            import { observeClick } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global--observer.js"; 
            import Swal from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-sweetalert2.js"; 
            observeClick(".neo-democontent-button", async (buttonNode) => { 
                buttonNode.disabled = true; 
                const originalHTML = buttonNode.innerHTML; 
                buttonNode.innerHTML = "…"; 
                try { 
                    const response = await fetch("<?php echo \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/demo-content-import") ?>", { 
                        method: "POST", 
                        headers: { "Content-Type": "application/json", "X-WP-Nonce": "<?php echo wp_create_nonce("wp_rest") ?>" } 
                    });
                    if (!response.ok) { 
                        const errorText = await response.text(); 
                        Swal.fire({ 
                            icon: "error",
                            title: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("Error", "Fehler"); ?>",
                            text: errorText || "<?php echo \NeoRenameBeta\NeoGlobal\neo__("An error occurred while importing demo content.", "Beim Importieren der Demo-Inhalte ist ein Fehler aufgetreten."); ?>"
                        });
                        return; 
                    }
                    const importedItems = await response.json(); 
                    if (Array.isArray(importedItems) && importedItems.length > 0) { 
                        let listHtml = "<ul>"; 
                        importedItems.forEach(item => { listHtml += "<li>" + item.filename + " (" + item.slug + ")" + "</li>"; }); 
                        listHtml += "</ul>"; 
                        document.querySelector(".neo-democontent-results").innerHTML = listHtml; 
                        Swal.fire({ 
                            icon: "success",
                            title: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("Success", "Erfolg"); ?>",
                            html: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("Demo content imported successfully. See list below:", "Demo-Inhalte erfolgreich importiert. Siehe Liste unten:"); ?>" + listHtml 
                        });
                    } else { 
                        Swal.fire({ 
                            icon: "info",
                            title: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("No items imported", "Keine Elemente importiert"); ?>",
                            text: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("No demo content items were returned.", "Es wurden keine Demo-Inhalte zurückgegeben."); ?>"
                        });
                    }
                } catch (error) { 
                    Swal.fire({ 
                        icon: "error",
                        title: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("Error", "Fehler"); ?>",
                        text: error.message || "<?php echo \NeoRenameBeta\NeoGlobal\neo__("An unexpected error occurred.", "Ein unerwarteter Fehler ist aufgetreten."); ?>"
                    });
                } finally { 
                    buttonNode.disabled = false; 
                    buttonNode.innerHTML = originalHTML; 
                }
            });
        </script>
        <?php
    };
    \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoMenu\interface_add_neo_menu_page_20250604')(
        id: "neo-democontent",
        icon: \NeoRenameBeta\NeoGlobal\plugin_url() . "/img/plugin-module-neo-democontent-icon.svg",
        title: \NeoRenameBeta\NeoGlobal\neo__("neoDemo", "neoDemo"),
        description: \NeoRenameBeta\NeoGlobal\neo__("A demo is worth 1000 words.", "Ein Demo sagt mehr als 1000 Worte."),
        render_callback: $menu_render_callback
    );
});


\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {
    if (!\NeoRenameBeta\NeoGlobal\is_playground()) { return; }
    if (get_option("neo-democontent-imported", "false") === "true") { return; } update_option("neo-democontent-imported", "true");
    import_demo_content();
});
