<?php
namespace NeoRenameBeta\NeoLog;







function get_caller_log_source() {
    $backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);
    
    foreach ($backtrace as $frame) {
        if (!isset($frame["file"])) { continue; }
        if (str_ends_with($frame["file"], "neo-log-warn-error--init.php") || str_ends_with($frame["file"], "_global--log.php")) { continue; }
        if (str_ends_with($frame["file"], "_global--interface.php"))                                                            { continue; }
        $rel_path = \NeoRenameBeta\NeoGlobal\make_plugin_file_path_relative($frame["file"]);
        if (str_starts_with($rel_path, "neo-")) { return \NeoRenameBeta\NeoGlobal\get_module_name($rel_path); }
        $log_source_filename = basename($frame["file"]);
        return str_replace(".php", "", str_replace("/", "_", $log_source_filename));
    }
    return "[Unknown log source]";
}


function interface_global_log_20250325($message_array, $log_source = null) {
    if (!is_array($message_array)) { throw new \Exception("Log message must be an array"); }
    
    $log_source ??= get_caller_log_source();
    
    $log_file_path = \NeoRenameBeta\NeoGlobal\cache_path("neo-log") . "/" . $log_source . ".log";
    $log_line = \NeoRenameBeta\NeoGlobal\json_encode_better(["date" => \NeoRenameBeta\NeoGlobal\utc_date_string(), "plugin" => \NeoRenameBeta\NeoEntrypoint\plugin_slug() . "-" . \NeoRenameBeta\NeoEntrypoint\plugin_edition() . "." . \NeoRenameBeta\NeoEntrypoint\plugin_version()] + $message_array) . "\n";
    \NeoRenameBeta\NeoGlobal\synclock_dir(dirname($log_file_path), function () use ($log_file_path, $log_line) {
        file_put_contents($log_file_path, $log_line, FILE_APPEND);
        
        $log_file_size = filesize($log_file_path);
        if ($log_file_size > (2) * 1000000) {
            
            $log_file_lines = explode("\n", file_get_contents($log_file_path));
            $log_file_lines = array_slice($log_file_lines, intval(ceil(count($log_file_lines) * (90) / 100)));
            file_put_contents($log_file_path, implode("\n", $log_file_lines));
        }
    });
}


function interface_additional_message_for_errors_20250505() {
    if (get_option("neo-debug-shorten-additional-message") === "true") { return " 🙋‍♂️"; }
    return " 🙋‍♂️ Das neoWP-Team setzt sich stark für die Verbesserung der neoPlugins ein. Wir schätzen deine Fehlerberichte. Für eine schnelle Lösung melde bitte das Problem mit einem Screenshot. Du hörst in Kürze von uns. Danke! 💌 urgent@neo-wp.com 🎁";
}


function interface_global_warn_20250325($message, $log_source = null) {
    
    $log_source ??= get_caller_log_source();
    
    trigger_error("$log_source: " . esc_html($message) . " - " . interface_additional_message_for_errors_20250505(), E_USER_WARNING);
    
    interface_global_log_20250325(["message" => $message],                         log_source: $log_source);
    interface_global_log_20250325(["message" => "Warning: $log_source: $message"], log_source: "error");
    
    \NeoRenameBeta\NeoGlobal\add_action_hook("wp_footer",    function () use ($log_source, $message) { ?><script>console.warn("neoWP PHP warning for <?php echo $log_source; ?>:", <?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object($message) ?>);</script><?php });
    \NeoRenameBeta\NeoGlobal\add_action_hook("admin_footer", function () use ($log_source, $message) { ?><script>console.warn("neoWP PHP warning for <?php echo $log_source; ?>:", <?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object($message) ?>);</script><?php });
}


\NeoRenameBeta\NeoGlobal\add_action_hook("wp_head", "admin_head", function () { \NeoRenameBeta\NeoGlobal\enqueue_js("neo-log-warn-error.js"); });


$GLOBALS["neo_log_shown_admin_messages"] = [];
function interface_admin_success_20240424($message) {
    if (in_array($message, $GLOBALS["neo_log_shown_admin_messages"])) { return; } $GLOBALS["neo_log_shown_admin_messages"][] = $message;
    \NeoRenameBeta\NeoGlobal\add_action_hook("admin_notices", function () use ($message) { echo "<div class='notice notice-success'><p>$message</p></div>"; });
}

function interface_admin_warn_20250512($message, $suppress_additional_message = false) {
    if (in_array($message, $GLOBALS["neo_log_shown_admin_messages"])) { return; } $GLOBALS["neo_log_shown_admin_messages"][] = $message;
    \NeoRenameBeta\NeoGlobal\add_action_hook("admin_notices", function () use ($message, $suppress_additional_message) { echo "<div class='notice notice-warning'><p>" . $message . ($suppress_additional_message ? "" : ("<br>" . interface_additional_message_for_errors_20250505())) . "</p></div>"; });
}

function interface_admin_error_20250512($message, $suppress_additional_message = false) {
    if (in_array($message, $GLOBALS["neo_log_shown_admin_messages"])) { return; } $GLOBALS["neo_log_shown_admin_messages"][] = $message;
    \NeoRenameBeta\NeoGlobal\add_action_hook("admin_notices", function () use ($message, $suppress_additional_message) { echo "<div class='notice notice-error'><p>" . $message . ($suppress_additional_message ? "" : ("<br>" . interface_additional_message_for_errors_20250505())) . "</p></div>"; });
}


\NeoRenameBeta\NeoGlobal\add_action_hook("wp_head", "admin_head", function () {
    ?>
    <script> 
        let debugReportHintShown = false; 
        
        function neoShowAdditionalMessage(e_rror) { 
            if (!e_rror || !((e_rror.stack || "") + (e_rror.message || "")).replace(new RegExp(location.hostname, "g"), "").includes("neo")) { return; } 
            
            if (debugReportHintShown) { return; } debugReportHintShown = true; 
            console.log(`%c${<?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object(interface_additional_message_for_errors_20250505()) ?>}`, 'background: linear-gradient(to bottom, <?php echo \NeoRenameBeta\NeoGlobal\transform_colors("#ff00ff") ?>, <?php echo \NeoRenameBeta\NeoGlobal\transform_colors("#00ff00") ?>), linear-gradient(to bottom, <?php echo \NeoRenameBeta\NeoGlobal\transform_colors("#ff00ff") ?>, <?php echo \NeoRenameBeta\NeoGlobal\transform_colors("#00ff00") ?>);background-size: 3px 100%, 3px 100%;background-repeat: no-repeat; background-position: left, right; padding: 0 8px;'); 
        }
        
        window.addEventListener("e" + "rror", async (e) => { 
            await new Promise(resolve => setTimeout(resolve, 0)); 
            neoShowAdditionalMessage(e["e" + "rror"]); 
        });
        
        window.addEventListener("unhandledrejection", async (e) => { 
            await new Promise(resolve => setTimeout(resolve, 0)); 
            neoShowAdditionalMessage(e["reason"]); 
        });
    </script>
    <?php
});


\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {
    $menu_render_callback = function () {?>
        <div>
            <p><?php echo \NeoRenameBeta\NeoGlobal\neo__("The neoLog reveals the inner workings of neoWP. It is useful for debugging.", "Der neoLog zeigt die inneren Abläufe von neoWP. Er ist nützlich zum Debuggen.") ?></p>
            <a class="button button-primary" target="_blank" href="<?php echo \NeoRenameBeta\NeoGlobal\get_backend_page_url("neo-log") ?>"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Open neoLog", "neoLog öffnen") ?></a>
        </div>
    <?php };
    \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoMenu\interface_add_neo_menu_page_20250604')(
        id: "neo-log",
        icon: \NeoRenameBeta\NeoGlobal\plugin_url() . "/img/plugin-module-neo-log-icon.svg",
        title: \NeoRenameBeta\NeoGlobal\neo__("neoLog", "neoLog"),
        description: \NeoRenameBeta\NeoGlobal\neo__("Find answers faster.", "Schneller Antworten finden."),
        render_callback: $menu_render_callback
    );
});
