<?php
namespace NeoRenameBeta\NeoManagerfull;










\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {
    if (\NeoRenameBeta\NeoGlobal\is_module_available("neo-managerpro") && !(in_array("neo-managerpro", \NeoRenameBeta\NeoGlobal\plugin_modules()) || in_array("*", \NeoRenameBeta\NeoGlobal\plugin_modules()))) { return; }
    
    $menu_render_callback = function () {
        
        if (true)                                                             { $user_type = "user"; }
        if (in_array("neoManagerShowBeta", \NeoRenameBeta\NeoGlobal\get_domain_settings())) { $user_type = "beta"; }
        if (in_array("neoManagerShowDev",  \NeoRenameBeta\NeoGlobal\get_domain_settings())) { $user_type = "dev";  }
        
        $plugin_list_url = \NeoRenameBeta\NeoGlobal\get_manager_list_url(user_type: $user_type);
        $plugin_list_resp = \NeoRenameBeta\NeoGlobal\curl_request($plugin_list_url, timeout: 2, suppress_error: true);
        if ($plugin_list_resp === false) { $plugin_list = null; }
        else { try { $plugin_list = \NeoRenameBeta\NeoGlobal\json_decode_better($plugin_list_resp); } catch (\Throwable $error) { $plugin_list = false; } }
        if (!is_array($plugin_list) || isset($_GET["neo-debug-show-update-error"])) {?>
            <script src="<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-web-component-card.js" data-web-component-name="neo-managerfull-card-blank"></script>
            <neo-managerfull-card-blank>
                <div style="display: flex; flex-direction: column;">
                    <h3 style="font-weight: bold; color: darkblue; margin-top: 0;"><?php echo \NeoRenameBeta\NeoGlobal\neo__("The neoPlugin list is currently not available", "Die neoPlugin-Liste derzeit nicht verfügbar") ?></h3>
                    <a href="https://neo-wp.com" target="_blank"><button class="button button-primary"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Download neoPlugins from the official website", "neoPlugins von der offiziellen Website herunterladen") ?></button></a>
                    <p><strong><?php echo \NeoRenameBeta\NeoGlobal\neo__("The update server is currently not available. Please try again later or contact the neoSupport.", "Der Update-Server ist aktuell nicht verfügbar. Bitte versuche es später erneut oder kontaktiere den neoSupport.") ?></strong></p>
                </div>
            </neo-managerfull-card-blank>
            <?php
            return;
        }
        ?>

            <style>

                #neo-managerfull-table { display: flex; flex-direction: column; width: fit-content; gap: 20px; }

                .neo-managerfull-controls     { display: flex; flex-direction: row; align-items: center; gap: 20px; }
                .neo-managerfull-cell-options { display: flex; flex-direction: row; }
                .neo-managerfull-dropdown     { margin: 0; font-size: 1.2em !important; border-radius: 10px 0 0 10px !important; margin-right: -1px; }
                .neo-managerfull-button-install { margin: 0; font-size: 1.2em !important; border-radius: 0 10px 10px 0 !important; font-size: 1.0em; background-color: #202020; color: white; border: none; cursor: pointer; padding: 0.5em 1em; border-radius: 0.5em; }

                .neo-managerfull-plugin-active-switch + .neo-managerfull-plugin-active-switch-fake-neo-managerfull { display: none; }
                .neo-managerfull-plugin-active-switch[data-neo-plugin-slug="neo-universe"]:not([checked]):not([loading]) + .neo-managerfull-plugin-active-switch-fake-neo-managerfull { display: block; }
                .neo-managerfull-plugin-active-switch[data-neo-plugin-slug="neo-universe"]:not([checked]):not([loading]) { display: none; }

                neo-managerfull-card:not(:has(.neo-managerfull-switch-cell neo-managerfull-switch[checked])) .neo-managerfull-cell-options { visibility: hidden; }

                .neo-managerfull-cell-options+.neo-managerfull-switch-cell { position: relative; }
                .neo-managerfull-cell-options+.neo-managerfull-switch-cell::before { content: "<?php echo \NeoRenameBeta\NeoGlobal\neo__("Activate", "Aktivieren") ?>"; font-size: 0.8em; color: #C0C0C0; position: absolute; top: -20px; left: 50%; transform: translateX(-50%); }
            </style>


            <script src="<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-web-component-manager-card.js" data-web-component-name="neo-managerfull-card"></script>
            <script src="<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-web-component-switch.js"       data-web-component-name="neo-managerfull-switch"></script>


            <div id="neo-managerfull-table">
                <?php foreach ($plugin_list as $plugin_data) { ?>

                    <neo-managerfull-card
                        
                        plugin-name="<?php echo esc_attr($plugin_data["plugin-name"])?>"
                        slogan="<?php echo esc_attr($plugin_data["plugin-slogan"])?>"
                        info-items=<?php echo "[]"?>
                        icon-url="<?php          echo esc_attr($plugin_data["plugin-icon-url"] ?? "")?>"
                        icon-animated-url="<?php echo esc_attr($plugin_data["plugin-icon-url-animated"] ?? $plugin_data["plugin-icon-url"] ?? "")?>"
                        <?php if (empty($plugin_data["plugin-bundles"][0]["versions"] ?? [])) { echo "coming-soon"; }?>
                        
                        <?php $installed_version = null;                         foreach (get_plugins() as $installed_plugin_entry_file_rel => $installed_plugin_data) { if ($installed_plugin_entry_file_rel === \NeoRenameBeta\NeoGlobal\get_plugin_entry_path_relative($plugin_data["plugin-slug"])) { $installed_version = $installed_plugin_data["Version"] ?? "?"; break; } }?>
                        <?php $active_version    = null; $active_edition = null; foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $active_neo_plugin) { if (($active_neo_plugin["slug"] ?? null) === $plugin_data["plugin-slug"]) { $active_version = $active_neo_plugin["version"] ?? "?"; $active_edition = $active_neo_plugin["edition"] ?? "?"; break; } }?>
                        data-neo-plugin-slug="<?php       echo esc_attr($plugin_data["plugin-slug"]) ?>" 
                        data-neo-installed-version="<?php echo esc_attr($installed_version ?? "") ?>" 
                        data-neo-active-edition="<?php    echo esc_attr($active_edition ?? "") ?>" 
                        data-neo-active-version="<?php    echo esc_attr($active_version ?? "") ?>" 
                        data-neo-new-version="<?php       echo esc_attr($plugin_data["plugin-bundles"][0]["versions"][0] ?? "") ?>" 
                        data-neo-changelog-url="<?php     echo esc_attr($plugin_data["plugin-changelog-url"] ?? "") ?>" 
                        data-neo-website-url="<?php       echo esc_attr($plugin_data["plugin-website-url"] ?? "") ?>" 
                    >

                        <div slot="controls" class="neo-managerfull-controls">

                            <?php if ($user_type !== "user") { ?>
                                <div class="neo-managerfull-cell-options">
                                    <select class="neo-managerfull-dropdown">
                                        <?php $is_option_selected = false;?>
                                        <?php foreach ($plugin_data["plugin-bundles"] as $edition_bundle) { ?>
                                            <?php foreach ($edition_bundle["versions"] as $version) { ?>
                                                <option value="<?php echo $edition_bundle["edition"] . "," . $version ?>" <?php if (($active_version === $version || (\NeoRenameBeta\NeoGlobal\is_alpha_update_version($active_version ?? "") && $version === "Alpha") || (\NeoRenameBeta\NeoGlobal\is_live_update_version($active_version ?? "") && $version === "Live")) && $active_edition === $edition_bundle["edition"]) { $is_option_selected = true; echo "selected"; } ?>><?php echo $edition_bundle["edition"] . " - " . $version ?></option>
                                            <?php } ?>
                                        <?php } ?>
                                        <?php 
                                                 if (!$is_option_selected && $active_version !== null) { ?><option value="<?php echo $active_edition . "," . $active_version ?>" disabled selected><?php echo $active_edition . " - " . $active_version ?></option><?php }
                                            else if (!$is_option_selected)                             { ?><option value="" disabled selected><?php echo \NeoRenameBeta\NeoGlobal\neo__("Not activated", "Nicht aktiviert") ?></option><?php }
                                        ?>
                                    </select>
                                    <button class="neo-managerfull-button-install"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Install", "Install") ?></button>
                                </div>
                            <?php } ?>

                            <div class="neo-managerfull-switch-cell">
                                <neo-managerfull-switch class="neo-managerfull-plugin-active-switch" 
                                    <?php if (in_array($plugin_data["plugin-slug"], array_map(fn ($p) => $p["slug"], \NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins()))) { echo "checked"; }?> 
                                    <?php if (empty($plugin_data["plugin-bundles"][0]["versions"] ?? [])) { echo "disabled"; }?>
                                    data-neo-plugin-slug="<?php echo esc_attr($plugin_data["plugin-slug"]) ?>" 
                                    data-neo-plugin-bundles="<?php echo esc_attr(\NeoRenameBeta\NeoGlobal\json_encode_better($plugin_data["plugin-bundles"])) ?>" 
                                ></neo-managerfull-switch>
                                <neo-managerfull-switch class="neo-managerfull-plugin-active-switch-fake-neo-managerfull" checked disabled title="<?php echo esc_attr(\NeoRenameBeta\NeoGlobal\neo__("The neoManager is included in another neoPlugin. It cannot be deactivated.", "Der neoManager ist in einem anderen neoPlugin enthalten. Er kann nicht deaktiviert werden.")) ?>"></neo-managerfull-switch>
                            </div>
                        </div>
                    </neo-managerfull-card>
                <?php } ?>
            </div>
        <?php

        if (in_array(\NeoRenameBeta\NeoEntrypoint\plugin_slug(), ["neo-demo", "neo-prod"]) || \NeoRenameBeta\NeoEntrypoint\plugin_edition() === "dev") {?>
            <script>
                function cleanUpNeoManagerFull(buttonNode) { 
                    
                    document.querySelectorAll(".neo-managerfull-cell-options").forEach(el => el.remove()); 
                    document.querySelectorAll("neo-managerfull-card[coming-soon]").forEach(el => el.removeAttribute("coming-soon")); 
                    document.querySelectorAll("neo-managerfull-card neo-managerfull-switch").forEach(el => el.onchange = async () => null); 
                    document.querySelectorAll("neo-managerfull-card neo-managerfull-switch:not([checked])").forEach(el => el.toggle()); 
                    
                    buttonNode.style.display = "none"; 
                    const infoText = document.createElement("strong"); 
                    infoText.textContent = "<?php echo \NeoRenameBeta\NeoGlobal\neo__("Hid options. All switches are now dummies (no installation).", "Optionen ausgeblendet. Alle Schalter sind jetzt Dummy-Schalter (keine Installation).") ?>"; 
                    buttonNode.parentNode.appendChild(infoText); 
                }
            </script>
            <div style="margin-top: 20px; text-align: center;">
                <button class="button button-secondary" onclick="cleanUpNeoManagerFull(event.target)"><?php echo \NeoRenameBeta\NeoGlobal\neo__("For demo screenshot: Hide all options and Coming-Soon banners", "Für Demo Screenshot: Alle Optionen und Coming-Soon-Banner verstecken") ?></button>
            </div>
        <?php }
    };
    \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoMenu\interface_add_neo_menu_page_20250604')(
        id: "neo-managerfull",
        icon: \NeoRenameBeta\NeoGlobal\plugin_url() . "/img/plugin-neo-universe-icon.svg",
        title: \NeoRenameBeta\NeoGlobal\neo__("neoManager", "neoManager"),
        description: \NeoRenameBeta\NeoGlobal\neo__("Activate, install or deactivate any neoPlugin.", "Aktiviere, installiere oder deaktiviere jedes neoPlugin."),
        render_callback: $menu_render_callback
    );

    $menu_asset_loading_callback = function () {
        \NeoRenameBeta\NeoGlobal\enqueue_js("neo-managerfull.js", "neoManagerData", ["managerEndpoint" => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/manager"), "managerNonce" => wp_create_nonce("wp_rest"), "hashEndpoint" => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/manager-hash"), "hashNonce" => wp_create_nonce("wp_rest")]);
    };
    \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoMenu\interface_add_neo_menu_asset_loading_callback_20250302')($menu_asset_loading_callback);
});



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/manager", "POST", "admin", function ($get_param) {
    $action        = $get_param("action");
    $plugin_slug   = $get_param("plugin-slug");
    $edition       = $get_param("edition");
    $version       = $get_param("version");
    $force_install = $get_param("force-install");
    if ($action === "activate") {
        
        $entry_file_path = WP_PLUGIN_DIR . "/" . \NeoRenameBeta\NeoGlobal\get_plugin_entry_path_relative($plugin_slug);
        $is_already_installed = file_exists($entry_file_path);
        $entry_file_content = $is_already_installed ? file_get_contents($entry_file_path) : "";
        $is_already_installed = $is_already_installed && str_contains($entry_file_content, "Edition: $edition") && str_contains($entry_file_content, "Version: $version");
        if (!$is_already_installed || $force_install) {
            $zip_url = \NeoRenameBeta\NeoGlobal\get_plugin_download_zip_file_url($plugin_slug, $edition, $version);
            if ($version === "Alpha") { $zip_url = "https://neo-wp.com/wp-json/neo/bundler-action?plugin-slug=$plugin_slug&edition=$edition&action=alpha"; }
            if ($version === "Live")  { $zip_url = "https://neo-wp.com/wp-json/neo/bundler-action?plugin-slug=$plugin_slug&edition=$edition&action=live"; }
            interface_install_zip_20250605($zip_url);
        }

        activate_plugin(\NeoRenameBeta\NeoGlobal\get_plugin_entry_path_relative($plugin_slug));
    } else if ($action === "deactivate") {
        deactivate_plugins(\NeoRenameBeta\NeoGlobal\get_plugin_entry_path_relative($plugin_slug));
    } else { throw new \Exception("Invalid action: " . $action); }
    exit;
});



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/manager-hash", "GET", "admin", function ($get_param) {
    $hash = "";
    foreach (\NeoRenameBeta\NeoGlobal\iterate_all_files(\NeoRenameBeta\NeoGlobal\plugin_path()) as $path) {
        $rel_path = \NeoRenameBeta\NeoGlobal\make_plugin_file_path_relative($path);
        if (!(\NeoRenameBeta\NeoGlobal\get_module_name($rel_path) === "neo-managerfull")) { continue; }
        $file_contents = file_get_contents($path);
        $file_contents = str_replace(\NeoRenameBeta\NeoGlobal\get_plugin_namespace_prefix(\NeoRenameBeta\NeoEntrypoint\plugin_slug(), \NeoRenameBeta\NeoEntrypoint\plugin_edition()), "", $file_contents);
        $file_contents = str_replace(\NeoRenameBeta\NeoGlobal\get_bundle_id_uppercase(    \NeoRenameBeta\NeoEntrypoint\plugin_slug(), \NeoRenameBeta\NeoEntrypoint\plugin_edition()), "", $file_contents);
        $file_contents = str_ireplace(\NeoRenameBeta\NeoEntrypoint\plugin_slug(),    "", $file_contents);
        $file_contents = str_ireplace(\NeoRenameBeta\NeoEntrypoint\plugin_edition(), "", $file_contents);
        $hash = md5($hash . $file_contents);
    }
    return ["hash" => $hash];
});
