import { observeOnce, observeClick, observeAttributes, domLoaded } from "./_global--observer.js";
import { neoError } from "./_global--log.js";
import { neo__ } from "./_global-translation.js";
import { reloadPage } from "./_global-reload-curtain.js";
import Swal from "./_global-sweetalert2.js";
import { neoLoadInterfaceFunc } from "./_global--interface.js";




observeAttributes("neo-managerfull-card", (cardNode) => { 
    const infoLinks = []; 
    const installedVersion = cardNode.getAttribute("data-neo-installed-version"); 
    const activeVersion    = cardNode.getAttribute("data-neo-active-version");    
         if (!installedVersion) { infoLinks.push({ label: neo__("Not installed", "Nicht installiert") }); }                        
    else if (!activeVersion)    { infoLinks.push({ label: installedVersion + neo__(" (Not activated)", " (Nicht aktiviert)") }); } 
    else { 
        infoLinks.push({ label: cardNode.getAttribute("data-neo-active-edition")[0].toUpperCase() + cardNode.getAttribute("data-neo-active-edition").slice(1) }); 
        infoLinks.push({ label: `v${activeVersion}`}); 
        const newestVersion = cardNode.getAttribute("data-neo-newest-version"); 
        if (newestVersion && newestVersion !== activeVersion && !activeVersion.includes(".l")) { infoLinks.push({ label: neo__("Update: ", "Update: ") + "v" + newestVersion }); } 
    }
    if (cardNode.getAttribute("data-neo-changelog-url")) { infoLinks.push({ label: neo__("Changelog", "Changelog"), url: cardNode.getAttribute("data-neo-changelog-url") }); } 
    if (cardNode.getAttribute("data-neo-website-url")) {   infoLinks.push({ label: neo__("Website", "Webseite"),    url: cardNode.getAttribute("data-neo-website-url") }); }   
    const newInfoItems = JSON.stringify(infoLinks); 
    if (cardNode.getAttribute("info-items") !== newInfoItems) { cardNode.setAttribute("info-items", newInfoItems); } 
});



async function getActivePlugins() { 
    await domLoaded(); 
    const activePlugins = []; 
    for (const pluginCardNode of document.querySelectorAll("neo-managerfull-card")) { 
        const [slug, edition, version] = [pluginCardNode.getAttribute("data-neo-plugin-slug"), pluginCardNode.getAttribute("data-neo-active-edition"), pluginCardNode.getAttribute("data-neo-active-version")]; 
        const switchNode = pluginCardNode.querySelector("neo-managerfull-switch.neo-managerfull-plugin-active-switch"); 
        if (switchNode.checked) { activePlugins.push({ slug, edition, version }); } 
    }
    return activePlugins; 
}


async function activateOrDeactivatePlugin(activate, pluginSlug, forceInstall = false) { 
    if (!pluginSlug) { throw new Error("Plugin slug is required"); } 
    try { 
        
        const neoManagerHashResponseBeforeChange = await fetch(neoManagerData.hashEndpoint, { method: "GET", headers: { "Content-Type": "application/json", "X-WP-Nonce": window.neoManagerData.hashNonce }}); 
        let neoManagerHashBeforeChange = null; if (neoManagerHashResponseBeforeChange.ok) { neoManagerHashBeforeChange = (await neoManagerHashResponseBeforeChange.json()).hash; } 
        if (neoManagerHashBeforeChange === null) { throw new Error("Error getting neoManager hash"); } 
        
        const pluginCardNode = document.querySelector(`neo-managerfull-card[data-neo-plugin-slug="${pluginSlug}"]`); 
        const pluginBundles = JSON.parse(pluginCardNode.querySelector("neo-managerfull-switch.neo-managerfull-plugin-active-switch").getAttribute("data-neo-plugin-bundles")); 
        
        let edition, version; 
        const editionAndVersionSelectNode = pluginCardNode.querySelector(".neo-managerfull-dropdown"); 
        if (editionAndVersionSelectNode?.value) { 
            edition = editionAndVersionSelectNode.value.split(",")[0]; version = editionAndVersionSelectNode.value.split(",")[1]; 
        } else { 
            edition = "full"; 
            const availableEditions = pluginBundles.map((bundle) => bundle.edition); 
            if (!availableEditions.includes(edition)) { edition = availableEditions[0]; } 
            const editionBundle = pluginBundles.find((bundle) => bundle.edition === edition); 
            version = editionBundle.versions[0]; 
            if (editionAndVersionSelectNode) { editionAndVersionSelectNode.value = `${edition},${version}`; } 
        }
        
        const activePlugins = await getActivePlugins(); 
        let isSymlinkPluginActive = false; try { isSymlinkPluginActive = await (await neoLoadInterfaceFunc("neo-rename", "neo-symlink.js", "interfaceIsSymlinkPluginActive20250611"))(); } catch (err) { isSymlinkPluginActive = false; } 
        if (!activate && !(activePlugins.filter(({slug, edition}) => (edition === "full" || edition === "beta" || slug === "neo-prod" || slug === "neo-web")).length > 0 || isSymlinkPluginActive)) { 
            if (pluginSlug === "neo-universe") { 
                
                Swal.fire({ 
                    icon: "error", title: neo__("Deactivating neoManager", "neoManager deaktivieren"), 
                    text: neo__("The neoManager can only be deactivated via the plugin page (or after another neoPlugin has been activated).", "Der neoManager kann nur über die Plugin-Seite deaktiviert werden (oder nachdem ein anderes neoPlugin aktiviert wurde)."), 
                    showCancelButton: true, 
                    confirmButtonText: neo__("Go to plugin page", "Zur Plugin-Seite"), cancelButtonText: neo__("Cancel", "Abbrechen"), 
                }).then((result) => { if (result.isConfirmed) { window.location.href = "/wp-admin/plugins.php"; } }); 
                throw new Error("abort"); 
            }
            
            const neoUniverseSwitch = document.querySelector('neo-managerfull-card[data-neo-plugin-slug="neo-universe"] neo-managerfull-switch.neo-managerfull-plugin-active-switch'); 
            if (!neoUniverseSwitch.checked) { await neoUniverseSwitch.toggle(); } 
        }
        
        if (version === "Live" || version === "Alpha") { 
            const bundlerAvailableResp = await fetch("https://neo-wp.com/wp-json/neo/bundler-is-available"); 
            if (!bundlerAvailableResp.ok) { 
                Swal.fire({ 
                    icon: "error", title: neo__("Error", "Fehler"), 
                    text: neo__("To install alpha/live version, you need an active neoBundler on the prod-server (e.g. with neoProd).", "Um die Alpha/Live-Version zu installieren, benötigst du einen aktiven neoBundler auf dem Prod-Server (z.B. mit neoProd)."), 
                });
                throw new Error("abort"); 
            }
        }
        
        const resp = await fetch(window.neoManagerData.managerEndpoint, { 
            method: "POST", 
            headers: { "Content-Type": "application/json", "X-WP-Nonce": window.neoManagerData.managerNonce }, 
            body: JSON.stringify({ "action": activate ? "activate" : "deactivate", "plugin-slug": pluginSlug, "edition": edition, "version": version, "force-install": forceInstall }) 
        });
        if (!resp.ok) { 
            neoError("Error installing plugin", await resp.text()); 
            throw new Error("Error installing plugin"); 
        }
        const respText = await resp.text(); 
        if (respText.includes("Download failed")) { 
            neoError("Error downloading plugin", respText); 
            throw new Error("Error downloading plugin"); 
        }
        
        pluginCardNode.setAttribute("data-neo-active-version", activate ? version : ""); 
        pluginCardNode.setAttribute("data-neo-active-edition", activate ? edition : ""); 
        
        for (const cb of interfaceObserveActivePlugins20250408.onPluginSwitchedCallbacks ?? []) { cb(); } 
        
        const neoManagerHashResponseAfterChange = await fetch(neoManagerData.hashEndpoint, { method: "GET", headers: { "Content-Type": "application/json", "X-WP-Nonce": window.neoManagerData.hashNonce }}); 
        let neoManagerHashAfterChange = null; if (neoManagerHashResponseAfterChange.ok) { neoManagerHashAfterChange = (await neoManagerHashResponseAfterChange.json()).hash; } 
        if (neoManagerHashBeforeChange !== neoManagerHashAfterChange) { reloadPage(); } 
    } catch (err) { 
        if (err.message !== "abort") { Swal.fire({ icon: "error", title: "Error", text: err.message }); } 
        throw err; 
    }
}



observeClick(".neo-managerfull-button-install", async (applyButtonNode) => { 
    const switchNode = applyButtonNode.parentNode.parentNode.querySelector("neo-managerfull-switch"); 
    if (switchNode.loading) { return; } 
    const pluginSlug = switchNode.getAttribute("data-neo-plugin-slug"); 
    const switchNodeCheckedBefore = switchNode.checked; 
    if (!switchNode.checked) { switchNode.checked = true; } 
    switchNode.loading = true; 
    document.title = "🔄 " + document.title; 
    try { 
        await activateOrDeactivatePlugin(true , pluginSlug, true ); 
        document.title = "✅ " + document.title; 
        setTimeout(() => { document.title = document.title.replace("✅ ", ""); }, 5000); 
    } catch (err) { 
        document.title = "❌ " + document.title; 
        setTimeout(() => { document.title = document.title.replace("❌ ", ""); }, 5000); 
        switchNode.checked = switchNodeCheckedBefore; 
        throw err; 
    }
    finally { switchNode.loading = false; document.title = document.title.replace("🔄 ", ""); } 
});



observeOnce(".neo-managerfull-switch-cell neo-managerfull-switch.neo-managerfull-plugin-active-switch", (switchCellNode) => { 
    switchCellNode.onchange = async ({ checked }) => { 
        const pluginSlug = switchCellNode.getAttribute("data-neo-plugin-slug"); 
        await activateOrDeactivatePlugin(checked , pluginSlug, false ); 
    };
});


export function interfaceObserveActivePlugins20250408(callback) { 
    interfaceObserveActivePlugins20250408.onPluginSwitchedCallbacks ??= []; 
    interfaceObserveActivePlugins20250408.onPluginSwitchedCallbacks.push(async () => { callback(await getActivePlugins()); }); 
    getActivePlugins().then(callback); 
}


const urlParams = new URLSearchParams(window.location.search); 
if (urlParams.get("neo-change-live-update-to-alpha") === "true") { 
    domLoaded(() => { 
        
        for (const cellOptionsNode of document.querySelectorAll(".neo-managerfull-cell-options")) { 
            const dropdownNode = cellOptionsNode.querySelector(".neo-managerfull-dropdown"); 
            if (!dropdownNode) { continue; } 
            const installedEditionAndVersion = dropdownNode.value; 
            const installedVersion = installedEditionAndVersion.split(",")[1]; 
            if (!(installedVersion === "Live")) { continue; } 
            const installedEdition = installedEditionAndVersion.split(",")[0]; 
            const newEditionAndVersion = installedEdition + ",Alpha"; 
            dropdownNode.value = newEditionAndVersion; 
            cellOptionsNode.querySelector(".neo-managerfull-button-install").click(); 
            cellOptionsNode.scrollIntoView({ behavior: "smooth", block: "center" }); 
        }
        document.querySelector("#wp-admin-bar-neo-live-update")?.remove(); 
    });
}
