<?php
namespace NeoRenameBeta\NeoMenu;




\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () { interface_add_neo_menu_page_20250604(
    id: "neo-pro",
    icon: \NeoRenameBeta\NeoGlobal\plugin_url() . "/img/plugin-module-neo-pro-icon.svg",
    title: \NeoRenameBeta\NeoGlobal\neo__("neoPro", "neoPro"),
    description: \NeoRenameBeta\NeoGlobal\neo__("All advantages of neoPro on one page.", "Alle Vorteile von neoPro auf einen Blick."),
    render_callback: function () {
        [$color_theme, $interface_ok] = \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoPro\interface_get_color_theme_20250530')();
        ?><div style="display: flex; flex-direction: column; align-items: flex-start;">
            <div style="display: flex; align-items: center; gap: 10px;">
                <script src="<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-web-component-switch.js" data-web-component-name="neo-menu-pro-switch"></script>
                <neo-menu-pro-switch data-neo-menu-pro-switch-name="color-theme" only-enabled-if-pro <?php if ($color_theme === "pro") { echo " checked"; } ?> label="<?php echo \NeoRenameBeta\NeoGlobal\neo__("Icons in neoPro colors (blue and gold)", "Icons in neoPro-Farben (blau und gold)") ?>"></neo-menu-pro-switch>
            </div><br><br>
            <img src="https://neo-wp.com/wp-content/uploads/neo-pro-advantages.svg" alt="neoWP Pro" style="width: 100%; max-width: 1000px; height: auto;">
            <?php 
[$pricing_url, $interface_ok] = \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoFreemius\interface_freemius_pricing_page_url_20250613')();
            if ($interface_ok) {
                ?><a href="<?php echo esc_attr($pricing_url) ?>"><button class="button button-primary"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Get neoPro now", "Jetzt neoPro holen") ?></button></a><?php 
            }
 ?>
        </div>

        <script type="module">
            import { observeOnce } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global--observer.js"; 
            import { reloadPage } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-reload-curtain.js"; 
            import Swal from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-sweetalert2.js";
            observeOnce("neo-menu-pro-switch", (toggleProSwitchNode) => { 
                toggleProSwitchNode.onchange = async ({ checked }) => { 
                    try {
                        const switchName = toggleProSwitchNode.getAttribute("data-neo-menu-pro-switch-name"); 
                        const resp = await fetch(<?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object(\NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/pro-switch")) ?>, { method: "POST", headers: { "Content-Type": "application/json", "X-WP-Nonce": <?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object(wp_create_nonce("wp_rest")) ?> }, body: JSON.stringify({ "switch-name": switchName, checked: checked.toString() }) }); 
                        if (!resp.ok) { throw new Error(await resp.text()); } 
                        if (switchName === "color-theme") { reloadPage(); } 
                    } catch (error) { 
                        Swal.fire({ icon: "error", title: "Error", text: error.message }); 
                        throw error; 
                    }
                };
            });
        </script><?php
    }
); });



\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {
    









});
