<?php
namespace NeoRenameBeta\NeoMenu;





function neo_menu_order() { return ["neo-symlink", "#section-neo-manager", "neo-managerfull", "neo-managerpro", "neo-managerstore", "neo-bundler", "neo-licenseserver", "#section-neo-settings", "neo-draw", "neo-log", "neo-debug", "neo-pro", "#section-neo-license", "neo-license", "#section-neo-support", "neo-democontent", "neo-reset", "neo-contact"]; }


$GLOBALS["neo_menu_pages"] ??= [];
function interface_add_neo_menu_page_20250604($id, $icon, $title, $description, $render_callback) {
    $GLOBALS["neo_menu_pages"][] = ["id" => $id, "icon" => $icon, "title" => $title, "description" => $description, "render_callback" => $render_callback];
}
$GLOBALS["neo_menu_asset_loading_callbacks"] ??= [];
function interface_add_neo_menu_asset_loading_callback_20250302($callback) { $GLOBALS["neo_menu_asset_loading_callbacks"][] = $callback; }


\NeoRenameBeta\NeoGlobal\add_action_hook("admin_menu", function () {
    
    $menu_entry_order_by_id = neo_menu_order();
    
    foreach ($GLOBALS["neo_menu_pages"] as $menu_page) {
        if (in_array($menu_page["id"], $menu_entry_order_by_id)) { continue; }
        [$neo_debug_admin_warnings_enabled, $interface_ok] = \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoDebug\interface_neo_debug_show_debug_warnings_20250507')();
        if ($interface_ok && $neo_debug_admin_warnings_enabled) { \NeoRenameBeta\NeoGlobal\admin_warn("Menu entry ID not found in order list: " . $menu_page["id"] . " Add it to the list in neo-menu.php."); }
        $menu_entry_order_by_id[]= $menu_page["id"];
    }

    $menu_page_hook_suffix_id = add_menu_page(
        \NeoRenameBeta\NeoGlobal\neo__("neoWP - Media plugins", "neoWP - Media plugins"),
        \NeoRenameBeta\NeoGlobal\neo__("neoWP", "neoWP"),
        "manage_options",
        \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug(),
        function () use ($menu_entry_order_by_id) {
            \NeoRenameBeta\NeoGlobal\disallow_enqueue("Use interface_add_neo_menu_asset_loading_callback_20250302 to enqueue JS/CSS on neo-menu pages.", function () use ($menu_entry_order_by_id) {
                ?><div class="wrap">
                    <h1 style="display:none;">neoWP</h1>
                    <style>
                        html { scroll-behavior: smooth; }
                        .neo-menu-spacer { height: 40px; margin: 0; border: none; }
                        .neo-menu-header { display: flex; gap: 10px; padding-top: 40px; padding-bottom: 40px; }
                        .neo-menu-header-text { display: flex; flex-direction: column; }
                        .neo-menu-header h1 { font-size: 2.5em; font-weight: normal; padding: 0; margin-top: -0.1em; }
                        .neo-menu-header span { font-size: 1.2em; color: #606060; }
                        .neo-menu-header img { width: 4.5em; height: 4.5em; margin-right: 0.5em; }
                    </style>
                    <script src="<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-web-component-card.js" data-web-component-name="neo-menu-card"></script>
                    <?php
                    $last_section_id = null;
                    foreach ($menu_entry_order_by_id as $settings_page_id) {
                        if (str_starts_with($settings_page_id, "#")) { ?><div id="<?php echo ltrim($settings_page_id, "#") ?>" class="neo-menu-section-scroll-anchor"></div><?php $last_section_id = $settings_page_id; continue; }
                        $setting_page = \NeoRenameBeta\NeoGlobal\array_filter_better($GLOBALS["neo_menu_pages"], fn ($entry) => $entry["id"] === $settings_page_id)[0] ?? null;
                        if ($setting_page === null) { continue; }
                        ?><div id="<?php echo $setting_page["id"] ?>" class="neo-menu-section">
                            <div class="neo-menu-header">
                                <img src="<?php echo $setting_page["icon"] ?>" alt="" />
                                <div class="neo-menu-header-text">
                                    <h1><?php echo $setting_page["title"] ?></h1>
                                    <span><?php echo $setting_page["description"] ?></span>
                                </div>
                            </div>
                            <?php if (!in_array($setting_page["id"], ["neo-managerfull", "neo-managerpro", "neo-managerstore", "neo-bundler"])) {?> <neo-menu-card><?php try { $setting_page["render_callback"](); } catch (\Throwable $e) { \NeoRenameBeta\NeoGlobal\global_warn("Error while rendering menu page: " . get_class($e) . ": " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine() . "\n" . $e->getTraceAsString()); } ?></neo-menu-card><?php } ?>
                            <?php if ( in_array($setting_page["id"], ["neo-managerfull", "neo-managerpro", "neo-managerstore", "neo-bundler"])) {?>                <?php try { $setting_page["render_callback"](); } catch (\Throwable $e) { \NeoRenameBeta\NeoGlobal\global_warn("Error while rendering menu page: " . get_class($e) . ": " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine() . "\n" . $e->getTraceAsString());  } ?><?php } ?>
                            <hr class="neo-menu-spacer" />
                        </div><?php
                    }
                ?></div>


                <style>
                    #toplevel_page_neowp > .wp-submenu > .wp-first-item { display: none; }
                </style>
                <script>
                    
                    const sections = document.querySelectorAll(".neo-menu-section-scroll-anchor"); 
                    addEventListener("scroll", () => { 
                        
                        const scrollY = window.scrollY; 
                        for (const anyLink of document.querySelectorAll("#toplevel_page_<?php echo \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() ?> li")) { anyLink.classList.remove("current"); } 
                        
                        if (Math.ceil(document.querySelector("html").scrollTop + document.querySelector("html").clientHeight) >= document.querySelector("html").scrollHeight) { 
                            document.querySelector(`#toplevel_page_neowp a[href="admin.php?page=<?php echo \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() ?><?php echo $last_section_id ?>"]`).parentElement.classList.add("current"); 
                            return; 
                        }
                        
                        for (const section of [...sections].reverse()) { 
                            if (section.offsetTop < scrollY + window.innerHeight / 2) { 
                                document.querySelector(`#toplevel_page_neowp a[href="admin.php?page=<?php echo \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() ?>#${section.getAttribute('id')}"]`).parentElement.classList.add("current"); 
                                break; 
                            }
                        }
                    });
                </script>
                <?php
            });
        },
        icon_url: "data:image/svg+xml;base64," . base64_encode(file_get_contents(\NeoRenameBeta\NeoGlobal\plugin_path() . "/img/neo-menu-icon.svg")),
    );

    \NeoRenameBeta\NeoGlobal\add_action_hook("load-$menu_page_hook_suffix_id", function () use ($menu_page_hook_suffix_id) {
        $hook = get_current_screen()->id;
        if (!($hook === $menu_page_hook_suffix_id)) { return; }
        foreach ($GLOBALS["neo_menu_asset_loading_callbacks"] as $callback) { try { $callback(); } catch (\Throwable $e) { \NeoRenameBeta\NeoGlobal\global_warn("Error while loading menu page assets: " . get_class($e) . ": " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine() . "\n" . $e->getTraceAsString()); } }
    });

    \NeoRenameBeta\NeoGlobal\add_action_hook("load-$menu_page_hook_suffix_id", function () {
        if (!(\NeoRenameBeta\NeoGlobal\is_module_available("neo-managerfull") && \NeoRenameBeta\NeoGlobal\is_module_available("neo-managerstore") && \NeoRenameBeta\NeoGlobal\is_module_available("neo-managerpro"))) { return; }
        \NeoRenameBeta\NeoGlobal\enqueue_js("neo-menu-manager-layout-horizontal.js");
    });

    foreach (\NeoRenameBeta\NeoGlobal\array_filter_better($menu_entry_order_by_id, fn ($entry) => str_starts_with($entry, "#")) as $submenu_page) {
        add_submenu_page(
            \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug(),
            $submenu_page,
            [
                "#section-neo-manager"  => \NeoRenameBeta\NeoGlobal\neo__("neoManager", "neoManager"),
                "#section-neo-settings" => \NeoRenameBeta\NeoGlobal\neo__("Settings", "Einstellungen"),
                "#section-neo-license"  => \NeoRenameBeta\NeoGlobal\neo__("License", "Lizenz"),
                "#section-neo-support"  => \NeoRenameBeta\NeoGlobal\neo__("Support", "Support"),
            ][$submenu_page],
            "manage_options",
            \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() . $submenu_page,
            function () {},
        );
    }
});



\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {
    foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $neo_plugin) {
        \NeoRenameBeta\NeoGlobal\add_filter_hook("plugin_action_links_" . plugin_basename($neo_plugin["plugin_entry_file_path"] ?? ""), function ($links) {
            array_unshift($links, '<a href="admin.php?page=' . \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() . '">' . \NeoRenameBeta\NeoGlobal\neo__("Settings", "Einstellungen") . '</a>');
            return $links;
        });
    }
});



\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () { interface_add_neo_menu_page_20250604(
    id: "neo-contact",
    icon: \NeoRenameBeta\NeoGlobal\plugin_url() . "/img/plugin-module-neo-support-icon.svg",
    title: \NeoRenameBeta\NeoGlobal\neo__("neoSupport", "neoSupport"),
    description: \NeoRenameBeta\NeoGlobal\neo__("Message us about what's on your mind.", "Schreib uns, was dir auf dem Herzen liegt."),
    render_callback: function () {?>
        <div style="display:flex;flex-direction:row;flex-wrap:wrap;">
            


            <a href="https://neo-wp.com/contact/#free" target="_blank" class="button button-primary"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Contact us directly", "Kontaktiere uns direkt") ?></a>
        
        </div>
    <?php }
); });
