<?php
namespace NeoRenameBeta\NeoPluginupdate;









\NeoRenameBeta\NeoGlobal\add_filter_hook("site_transient_update_plugins:max", function ($transient) {
    if (\NeoRenameBeta\NeoGlobal\is_playground()) { return $transient; }
    
    if ($transient === false) {
        $transient = (object) [
            "response"  => [],
            "no_update" => [],
            "checked"   => [],
        ];
    }

    foreach (\NeoRenameBeta\NeoEntrypoint\get_neo_active_plugins() as $plugin) {
        if (!in_array($plugin["edition"], ["full", "beta", "pro"])) { continue; }
        
        $plugin_file = \NeoRenameBeta\NeoGlobal\get_plugin_entry_path_relative($plugin["slug"]);
        
        if (isset($transient->response[$plugin_file]))  { unset($transient->response[$plugin_file]); }
        if (isset($transient->no_update[$plugin_file])) { unset($transient->no_update[$plugin_file]); }
        if (isset($transient->checked[$plugin_file]))   { unset($transient->checked[$plugin_file]); }
        
        $info_url = \NeoRenameBeta\NeoGlobal\get_plugin_info_json_file_url($plugin["slug"], $plugin["edition"]);
        $plugin_info = (object) [
            "slug"        => $plugin["slug"] . "," . $plugin["edition"],
            "plugin"      => $plugin_file,
            "new_version" => \NeoRenameBeta\NeoEntrypoint\plugin_version(),
            "tested"      => "",
            "url"         => "https://neo-wp.com/",
            "package"     => "",
        ];
        try {
            
            static $curl_cache = [];
            if (isset($curl_cache[$info_url])) {
                $new_plugin_info = $curl_cache[$info_url];
                if ($new_plugin_info === "#cachedNeoPluginUpdateError") { throw new \Exception("#cachedNeoPluginUpdateError"); }
            }
            else {
                
                $curl_cache_file = \NeoRenameBeta\NeoGlobal\cache_path("neo-pluginupdate") . "/" . \NeoRenameBeta\NeoGlobal\get_bundle_slug($plugin["slug"], $plugin["edition"]) . ".json";
                if (file_exists($curl_cache_file) && filemtime($curl_cache_file) < time() - (6) * 60) { unlink($curl_cache_file); }
                if (file_exists($curl_cache_file)) { $response = file_get_contents($curl_cache_file); }
                else {
                    
                    $response = \NeoRenameBeta\NeoGlobal\curl_request($info_url, timeout: 10);
                    file_put_contents($curl_cache_file, $response);
                }
                $new_plugin_info = json_decode($response);
                if (!is_object($new_plugin_info)) { \NeoRenameBeta\NeoGlobal\global_warn("Plugin update error: Invalid JSON format for $info_url"); continue; }
                $curl_cache[$info_url] = $new_plugin_info;
            }
            $plugin_info->new_version = $new_plugin_info->version;
            $plugin_info->package     = $new_plugin_info->download_link;
            $plugin_info->tested      = $new_plugin_info->tested_with_patch ?? "";
            $plugin_info->icons = [
                "1x" => \NeoRenameBeta\NeoGlobal\plugin_icon_url(),
                "2x" => \NeoRenameBeta\NeoGlobal\plugin_icon_url(),
            ];
            if (json_last_error() !== JSON_ERROR_NONE) { throw new \Exception("Ungültiges JSON-Format"); }
            if (version_compare($plugin_info->new_version, \NeoRenameBeta\NeoGlobal\plugin_version_without_live_timestamp($plugin["version"]), ">")) { $transient->response[$plugin_file]  = $plugin_info; }
            else                                                                                                                       { $transient->no_update[$plugin_file] = $plugin_info; }
        } catch (\Throwable $e) {
            if (($curl_cache[$info_url] ?? null) !== "#cachedNeoPluginUpdateError") { \NeoRenameBeta\NeoGlobal\global_warn("Plugin update error for $plugin_file: " . $e->getMessage()); }
            $curl_cache[$info_url] = "#cachedNeoPluginUpdateError";
            $transient->no_update[$plugin_file] = $plugin_info;
            continue;
        } finally {
            $transient->checked[$plugin_file] = $plugin["version"];
        }
    }
    return $transient;
});


\NeoRenameBeta\NeoGlobal\add_filter_hook("plugins_api", function ($result, $action, $args) {
    if ($action !== "plugin_information" || empty($args->slug)) { return $result; }
    if (!str_starts_with($args->slug, "neo-")) { return $result; }
    
    try {
        $response = \NeoRenameBeta\NeoGlobal\curl_request(\NeoRenameBeta\NeoGlobal\get_plugin_info_json_file_url(explode(",", $args->slug)[0], explode(",", $args->slug)[1]), timeout: 10);
        $plugin_info = \NeoRenameBeta\NeoGlobal\json_decode_better($response);
        return (object)[
            "name"           => $plugin_info["name"],
            "slug"           => $args->slug,
            "version"        => $plugin_info["version"]        ?? "",
            "author"         => $plugin_info["author"]         ?? "",
            "author_profile" => $plugin_info["author_profile"] ?? "",
            "requires"       => $plugin_info["requires"]       ?? "",
            "requires_php"   => $plugin_info["requires_php"]   ?? "",
            "tested"         => $plugin_info["tested"]         ?? "",
            "last_updated"   => $plugin_info["last_updated"]   ?? "",
            "sections"       => array_intersect_key(array_change_key_case((array)($plugin_info["sections"] ?? []), CASE_LOWER), array_flip(["description", "installation", "faq", "changelog", "screenshots"])),
            "banners"        => (array)($plugin_info["banner"] ?? []),
            "download_link"  => $plugin_info["download_link"]  ?? "",
        ];
    } catch (\Exception $e) {
        \NeoRenameBeta\NeoGlobal\global_warn("Plugin info error: " . $e->getMessage());
        return $result;
    }
});
