<?php
namespace NeoRenameBeta\NeoProinstaller;




\NeoRenameBeta\NeoGlobal\add_action_hook("admin_footer", function () {
    if (!(($_GET["page"] ?? "") === \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() || ($_GET["page"] ?? "") === \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug() . "-account")) { return; }
    
    $license_key = \NeoRenameBeta\NeoGlobal\get_freemius_license()?->secret_key;
    if ($license_key === null) { return; }
    
    if (\NeoRenameBeta\NeoEntrypoint\plugin_edition() === "dev") { return; }
    
    $is_pro_installer_allowed = \NeoRenameBeta\NeoGlobal\is_module_available("neo-managerfull");
    
    ?><script type="module"> 
        import { neo__ } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-translation.js"; 
        import { neoError } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global--log.js"; 
        import { reloadPage } from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-reload-curtain.js"; 
        import Swal from "<?php echo \NeoRenameBeta\NeoGlobal\plugin_url() ?>/_global-sweetalert2.js"; 
        const result = await Swal.fire({ 
            title: neo__("Activate neoMedia Pro", "neoMedia Pro aktivieren"), 
            html: `
                <p style="text-align: left;">
                    ${neo__(`You've entered a license key for neoMedia Pro. To use the Pro features, you need to install the Pro version of the plugin. What would you like to do?`,
                            `Du hast einen Lizenzschlüssel für neoMedia Pro eingegeben. Um die Pro-Funktionen nutzen zu können, musst du die Pro-Version des Plugins installieren. Was möchtest du tun?`)}
                </p>
            `,
            icon: "info", 
            reverseButtons: true, 
            showCancelButton: true, showDenyButton: true, showConfirmButton: <?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object($is_pro_installer_allowed) ?>, 
            cancelButtonText: neo__("Remove Key", "Schlüssel entfernen"), denyButtonText: neo__("Download ZIP", "ZIP herunterladen"), confirmButtonText: neo__("Install Now", "Jetzt installieren"), 
            cancelButtonColor:  "#DC3644", 
            denyButtonColor:    "#3085D6", 
            confirmButtonColor: "#28A744", 
            allowOutsideClick: false, 
            allowEscapeKey: true, 
            showLoaderOnConfirm: true, 
            preConfirm: async () => { 
                
                try {
                    const response = await fetch("<?php echo \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/proinstaller") ?>", { 
                        method: "POST",
                        headers: { "Content-Type": "application/json", "X-WP-Nonce": "<?php echo wp_create_nonce("wp_rest"); ?>" }, 
                        body: JSON.stringify({ action: "install-pro" }), 
                    });
                    if (!response.ok) { throw new Error("HTTP error " + response.status); } 
                    const respText = await response.text(); 
                    if (respText.includes("Download failed")) { 
                        neoError("Error downloading plugin", respText); 
                        throw new Error("Error downloading plugin - " + respText); 
                    }
                    
                    reloadPage(<?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object(admin_url("plugins.php")) ?>); 
                } catch (error) { 
                    alert(neo__("There was an error while installing neoMedia Pro: ", "Es gab einen Fehler beim Installieren von neoMedia Pro: ") + error.message); 
                    throw error; 
                }
            },
        });
        if (result.isDenied) { 
            window.open(<?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object(\NeoRenameBeta\NeoGlobal\get_plugin_download_zip_file_url_without_version("neo-media", "pro")) ?> + "?license-key=" + encodeURIComponent(<?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object($license_key) ?>)); 
            reloadPage(); 
        } else if (result.dismiss === Swal.DismissReason.cancel) { 
            
            try {
                const response = await fetch("<?php echo \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/proinstaller") ?>", { 
                    method: "POST",
                    headers: { "Content-Type": "application/json", "X-WP-Nonce": "<?php echo wp_create_nonce("wp_rest"); ?>" }, 
                    body: JSON.stringify({ action: "remove-license-key" }), 
                });
                if (!response.ok) { throw new Error("HTTP error " + response.status); } 
                const data = await response.json(); 
                reloadPage(<?php echo \NeoRenameBeta\NeoGlobal\php_to_js_object(admin_url("admin.php?page=" . \NeoRenameBeta\NeoEntrypoint\plugin_menu_slug())) ?>); 
            } catch (error) { 
                alert(neo__("There was an error while removing the license key: ", "Es gab einen Fehler beim Entfernen des Lizenzschlüssels: ") + error.message); 
                throw error; 
            }
        }
    </script>
    <?php
});



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/proinstaller", "POST", "admin", function ($get_param) {
    $action = $get_param("action") ?? "";
    if ($action === "install-pro") {
        $license_key = \NeoRenameBeta\NeoGlobal\get_freemius_license()->secret_key;
        if ($license_key === null) { return new \WP_Error("no_license_key", "No license key set.", ["status" => 400]); }
        $zip_url = \NeoRenameBeta\NeoGlobal\get_plugin_download_zip_file_url_without_version("neo-media", "pro") . "?license-key=" . urlencode($license_key);
        \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoManagerfull\interface_install_zip_20250605', throw_if_interface_not_ok: true)($zip_url);
        activate_plugin(\NeoRenameBeta\NeoGlobal\get_plugin_entry_path_relative("neo-media"));
        exit;
    } else if ($action === "remove-license-key") {
        \NeoRenameBeta\NeoGlobal\freemius_instance()->delete_account_event();
        return "OKAY";
    }
});
