<?php
namespace NeoRenameBeta\NeoRename;




function interface_rename_media_file_20250302($media_id, $new_filename) {
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
    global $wpdb;

    
    if ($new_filename != sanitize_file_name($new_filename)) {
        return new \WP_Error("rest_forbidden", __("Invalid filename.", "wp-rest-api"), ["status" => 403]);
    }
    if (!wp_get_attachment_url($media_id)) {
        return new \WP_Error("rest_missing_image", __("Image does not exist.", "wp-rest-api"), ["status" => 404]);
    }
    if ($new_filename != strtolower($new_filename)) {
        return new \WP_Error("rest_forbidden", __("Invalid filename. The filename has to be all lowercase.", "wp-rest-api"), ["status" => 400]);
    }

    $replace_after_last_slash = function ($string, $replacement) {
        if (!str_contains($string, "/")) { return $replacement; }
        return preg_replace("#/[^/]*$#", "/" . $replacement, $string);
    };


    $old_image_path_absolute = get_attached_file($media_id);
    $old_image_path_relative = \NeoRenameBeta\NeoGlobal\post_meta($media_id, "_wp_attached_file");
    $old_image_filename      = basename($old_image_path_absolute);
    $old_image_url           = wp_get_attachment_url($media_id);

    
    if ($new_filename === $old_image_filename) {
        \NeoRenameBeta\NeoGlobal\global_log(["type" => "file", "postID" => $media_id, "oldFilename" => $old_image_filename, "newInput" => $new_filename, "newFileName" => $new_filename, "changes" => false]);
        return;
    }


    $image_dir = dirname($old_image_path_absolute);
    $new_filename = wp_unique_filename($image_dir, $new_filename);
    $new_filename = preg_replace("/-(scaled|rotated|(\d+x\d+))-\d+\./", "-$1.", $new_filename);
    $new_image_path = $replace_after_last_slash($old_image_path_relative, $new_filename);

    
    \NeoRenameBeta\NeoGlobal\global_log(["type" => "file", "imgId" => $media_id, "oldFilename" => $old_image_filename, "newInput" => $new_filename, "newFileName" => $new_filename, "changes" => true]);

    
    $filenames_to_replace = [];
    $old_metadata = \NeoRenameBeta\NeoGlobal\post_meta($media_id, "_wp_attachment_metadata");
    if (!is_array($old_metadata)) { $old_metadata = []; }
    $new_filename_base = pathinfo($new_filename, PATHINFO_FILENAME);
    $new_filename_base = preg_replace("/-(scaled|rotated)$/", "", $new_filename_base);
    
    $filenames_to_replace[] = ["old_filename" => $old_image_filename, "new_filename" => $new_filename];
    
    if (isset($old_metadata["sizes"])) {
        foreach ($old_metadata["sizes"] as $size) {
            $old_size_filename = $size["file"];
            $size_filename_extension = pathinfo($old_size_filename, PATHINFO_EXTENSION);
            $new_size_filename = $new_filename_base . "-{$size['width']}x{$size['height']}." . $size_filename_extension;
            $filenames_to_replace[] = ["old_filename" => $old_size_filename, "new_filename" => $new_size_filename];
        }
    }

    if (isset($old_metadata["original_image"])) {
        $old_original_filename = pathinfo($old_metadata["original_image"], PATHINFO_FILENAME) . "." . $size_filename_extension;
        $original_filename_extension = pathinfo($old_original_filename, PATHINFO_EXTENSION);
        $new_original_filename = $new_filename_base . "-original." . $original_filename_extension;
        $filenames_to_replace[] = ["old_filename" => $old_original_filename, "new_filename" => $new_original_filename];
    }

    foreach (["webp", "avif"] as $alternative_extension) {
        foreach ($filenames_to_replace as $filename) {
            
            $filenames_to_replace[] = [
                "old_filename" => pathinfo($filename["old_filename"], PATHINFO_FILENAME) . "." . $alternative_extension,
                "new_filename" => pathinfo($filename["new_filename"], PATHINFO_FILENAME) . "." . $alternative_extension
            ];

            $filenames_to_replace[] = [
                "old_filename" => $filename["old_filename"] . "." . $alternative_extension,
                "new_filename" => $filename["new_filename"] . "." . $alternative_extension
            ];
        }
    }

    $filenames_to_replace = \NeoRenameBeta\NeoGlobal\array_unique_better($filenames_to_replace);

    
    $filepaths_to_rename = [];
    $urls_to_replace = [];
    foreach ($filenames_to_replace as $filename) {
        
        $old_path_absolute = trailingslashit(dirname($old_image_path_absolute)) . $filename["old_filename"];
        $new_path_absolute = trailingslashit(dirname($old_image_path_absolute)) . $filename["new_filename"];
        
        if (!file_exists($old_path_absolute)) { continue; }
        $filepaths_to_rename[] = ["old_filepath" => $old_path_absolute, "new_filepath" => $new_path_absolute];
        
        $old_url = $replace_after_last_slash($old_image_url, $filename["old_filename"]);
        $new_url = $replace_after_last_slash($old_image_url, $filename["new_filename"]);
        $urls_to_replace[] = ["old_url" => $old_url, "new_url" => $new_url];
    }



    $wpdb->query("START TRANSACTION");
    $do_database_rollback = false;
    
    $new_metadata = unserialize(serialize($old_metadata));
    $deep_replace_string_in_array = function (&$array, $search, $replace) use (&$deep_replace_string_in_array) {
        foreach ($array as &$value) {
            if (is_string($value)) { $value = str_replace($search, $replace, $value); }
            if (is_array($value)) { $deep_replace_string_in_array($value, $search, $replace); }
        }
    };
    foreach ($filenames_to_replace as $filename_to_replace) {
        $deep_replace_string_in_array($new_metadata, $filename_to_replace["old_filename"], $filename_to_replace["new_filename"]);
    }
    update_post_meta($media_id, "_wp_attachment_metadata", wp_slash($new_metadata));
    
    update_post_meta($media_id, "_wp_attached_file", wp_slash($new_image_path));
    
    $sql_scripts = [];
    
    
    
    
    $replacements1 = [];
    $replacements2 = [];
    foreach ($urls_to_replace as $url_to_replace) {
        $old_image_url_absolute = $url_to_replace["old_url"];
        $new_image_url_absolute = $url_to_replace["new_url"];
        $old_image_url_absolute_http = str_replace("https://", "http://", $old_image_url_absolute);
        $new_image_url_absolute_http = str_replace("https://", "http://", $new_image_url_absolute);
        $old_image_url_absolute_https = str_replace("http://", "https://", $old_image_url_absolute);
        $new_image_url_absolute_https = str_replace("http://", "https://", $new_image_url_absolute);
        $old_image_url_relative = str_replace(site_url(), "", $old_image_url_absolute);
        $new_image_url_relative = str_replace(site_url(), "", $new_image_url_absolute);
        $old_image_url_relative_no_first_slash = ltrim($old_image_url_relative, "/");
        $new_image_url_relative_no_first_slash = ltrim($new_image_url_relative, "/");
        $old_filename_with_dir = str_replace(untrailingslashit(\NeoRenameBeta\NeoGlobal\get_url_path(content_url())) . "/uploads/", "", $old_image_url_relative);
        $new_filename_with_dir = str_replace(untrailingslashit(\NeoRenameBeta\NeoGlobal\get_url_path(content_url())) . "/uploads/", "", $new_image_url_relative);
        $old_filename_without_dir = basename($old_image_url_relative);
        $new_filename_without_dir = basename($new_image_url_relative);
        
        $replacements1[]= ["old_str" => 's:' . strlen($old_image_url_absolute_https)          . ':"' . $old_image_url_absolute_https          . '"', "new_str" => 's:' . strlen($new_image_url_absolute_https)          . ':"' . $new_image_url_absolute_https          . '"' ];
        $replacements1[]= ["old_str" => 's:' . strlen($old_image_url_absolute_http)           . ':"' . $old_image_url_absolute_http           . '"', "new_str" => 's:' . strlen($new_image_url_absolute_http)           . ':"' . $new_image_url_absolute_http           . '"' ];
        $replacements1[]= ["old_str" => 's:' . strlen($old_image_url_relative)                . ':"' . $old_image_url_relative                . '"', "new_str" => 's:' . strlen($new_image_url_relative)                . ':"' . $new_image_url_relative                . '"' ];
        $replacements1[]= ["old_str" => 's:' . strlen($old_image_url_relative_no_first_slash) . ':"' . $old_image_url_relative_no_first_slash . '"', "new_str" => 's:' . strlen($new_image_url_relative_no_first_slash) . ':"' . $new_image_url_relative_no_first_slash . '"' ];
        $replacements1[]= ["old_str" => 's:' . strlen($old_filename_with_dir)                 . ':"' . $old_filename_with_dir                 . '"', "new_str" => 's:' . strlen($new_filename_with_dir)                 . ':"' . $new_filename_with_dir                 . '"' ];
        $replacements1[]= ["old_str" => 's:' . strlen($old_filename_without_dir)              . ':"' . $old_filename_without_dir              . '"', "new_str" => 's:' . strlen($new_filename_without_dir)              . ':"' . $new_filename_without_dir              . '"' ];
        $replacements2[]= ["old_str" => $old_image_url_relative_no_first_slash                                                                     , "new_str" => $new_image_url_relative_no_first_slash,                                                                     ];
        $replacements2[]= ["old_str" => substr(json_encode(["x" => $old_image_url_relative_no_first_slash]), 6, -2)                                , "new_str" => substr(json_encode(["x" => $new_image_url_relative_no_first_slash]), 6, -2)                                 ];
        
    }

    $replacements1 = \NeoRenameBeta\NeoGlobal\array_unique_better($replacements1);
    $replacements2 = \NeoRenameBeta\NeoGlobal\array_unique_better($replacements2);
    
    $replacing_file_extensions = \NeoRenameBeta\NeoGlobal\array_unique_better(array_map(function($url) { return strtolower(pathinfo($url["old_url"], PATHINFO_EXTENSION)); }, $urls_to_replace));
    $regexp_replacing_file_extensions_filter = "(?i)\\\\.(" . implode("|", array_map("preg_quote", $replacing_file_extensions)) . ")";
    
    $table_columns_including_images = [];
    foreach ($wpdb->get_results("SHOW TABLES", ARRAY_N) as $table) {
        $table_name = $table[0];
        if (strpos($table_name, $wpdb->prefix) !== 0) { continue; }
        foreach ($wpdb->get_results("SHOW COLUMNS FROM `$table_name`") as $column) {
            if (!(strpos($column->Type, "char") !== false || strpos($column->Type, "text") !== false)) { continue; }
            
            $column_name = $column->Field;
            $result = $wpdb->get_results("SELECT * FROM `$table_name` WHERE `$column_name` REGEXP '$regexp_replacing_file_extensions_filter' LIMIT 1;");
            if (count($result) > 0) {
                if (!isset($table_columns_including_images[$table_name])) { $table_columns_including_images[$table_name] = []; }
                $table_columns_including_images[$table_name][] = $column_name;
            }
        }
    }

    foreach ($table_columns_including_images as $table_name => $columns) {
        
        
        
        
        
        
        
        
        
        
        $sql_cmd = "UPDATE `" . $table_name . "` SET ";
        foreach ($columns as $column_name) {
            $sql_cmd .= "`" . $column_name . "` = CASE ";
            
            $sql_cmd .= "WHEN `" . $column_name . "` ";
            $sql_cmd .= "REGEXP '^(?:a|O|s):' THEN ";
            $sql_cmd .= str_repeat("REPLACE(", count($replacements1));
            $sql_cmd .= "`" . $column_name . "`";
            foreach ($replacements1 as $replacement) { $sql_cmd .= ", '" . esc_sql($replacement["old_str"]) . "', '" . esc_sql($replacement["new_str"]) . "')"; }
            
            $sql_cmd .= " WHEN `" . $column_name . "` ";
            $sql_cmd .= "NOT REGEXP '^(?:a|O|s):' THEN ";
            $sql_cmd .= str_repeat("REPLACE(", count($replacements2));
            $sql_cmd .= "`" . $column_name . "`";
            foreach ($replacements2 as $replacement) { $sql_cmd .= ", '" . esc_sql($replacement["old_str"]) . "', '" . esc_sql($replacement["new_str"]) . "')"; }
            
            $sql_cmd .= " ELSE `" . $column_name . "` ";
            $sql_cmd .= "END, ";
        }
        $sql_cmd = rtrim($sql_cmd, ", ");
        $sql_cmd .= " WHERE ";
        foreach ($columns as $column_name) { $sql_cmd .= "`$column_name` REGEXP '$regexp_replacing_file_extensions_filter' OR "; }
        $sql_cmd = rtrim($sql_cmd, " OR ");
        $sql_cmd .= ";";
        
        $sql_scripts[] = $sql_cmd;
    }

    $error_string = null;
    foreach ($sql_scripts as $sql_script) {
        $success = $wpdb->query($sql_script);
        if ($success === false) {
            $do_database_rollback = true;
            $error_string = "Error while renaming URLs in database. SQL command: " . $sql_script;
            break;
        }
    }



    $successfully_renamed_files = [];
    if ($error_string === null) {
        foreach ($filepaths_to_rename as $file_to_rename) {
            
            if (!is_writable($file_to_rename["old_filepath"])) {
                $error_string = "Error while renaming file on disk. The file " . $file_to_rename["old_filepath"] . " is not writable. Please check the file permissions.";
                break;
            }

            if (file_exists($file_to_rename["new_filepath"])) {
                $error_string = "Error while renaming file on disk. The target file name " . $file_to_rename["new_filepath"] . " already exists.";
                break;
            }

            if (rename($file_to_rename["old_filepath"], $file_to_rename["new_filepath"])) {
                $successfully_renamed_files[] = $file_to_rename;
            } else {
                $error_string = "Error while renaming file on disk: " . $file_to_rename["old_filepath"] . " to " . $file_to_rename["new_filepath"];
                break;
            }
        }
    }


    if ($error_string === null) {
        $wpdb->query("COMMIT");
        
        clean_post_cache($media_id);
        \NeoRenameBeta\NeoGlobal\flush_all_third_party_caches();
        clean_post_cache($media_id);
    } else {
        
        foreach ($successfully_renamed_files as $successfully_renamed_file) {
            rename($successfully_renamed_file["new_filepath"], $successfully_renamed_file["old_filepath"]);
        }

        if ($do_database_rollback) { $wpdb->query("ROLLBACK"); }
        
        return new \WP_Error("rest_rename_error", $error_string, ["status" => 500]);
    }
}


function rename_update_title($img_id, $new_title) {
    global $wpdb;
    \NeoRenameBeta\NeoGlobal\global_log(["type" => "title", "imgId" => $img_id, "oldTitle" => get_post_field("post_title", $img_id), "newTitle" => $new_title]);
    $success = $wpdb->update($wpdb->posts, ["post_title" => $new_title], ["ID" => $img_id], ["%s"], ["%d"]);
    clean_post_cache($img_id);
    return $success;
}


function rename_update_slug($image_id, $new_slug_input) {
    global $wpdb;

    
    $old_slug = get_post_field("post_name", $image_id);
    if ($old_slug === $new_slug_input) {
        $new_slug = $old_slug;
    } else {
        
        $new_slug = wp_unique_post_slug($new_slug_input, $image_id, get_post_field("post_status", $image_id), get_post_field("post_type", $image_id), get_post_field("post_parent", $image_id));
    }


    \NeoRenameBeta\NeoGlobal\global_log(["type" => "slug", "imgId" => $image_id, "oldSlug" => $old_slug, "newInput" => $new_slug_input, "newSlug" => $new_slug]);


    $wpdb->query("START TRANSACTION");
    $query_resp = $wpdb->query($wpdb->prepare("UPDATE {$wpdb->posts} SET post_name = %s WHERE ID = %d", $new_slug, $image_id));
    if ($query_resp === false) {
        $db_error = $wpdb->last_error;
        $wpdb->query("ROLLBACK");
        return new \WP_Error("rest_rename_error", \NeoRenameBeta\NeoGlobal\neo__("Error while renaming slug in database.", "Fehler beim Umbenennen des Slugs in der Datenbank.") . " " . $db_error, ["status" => 500]);
    }

    $wpdb->query("COMMIT");

    
    clean_post_cache($image_id);
}


\NeoRenameBeta\NeoGlobal\activate_image_cache_bust();



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/rename", "POST", "editor", function ($get_param) {
    
    $old_img_url = $get_param("img-url");
    $img_id = attachment_url_to_postid($old_img_url);
    if ($img_id === 0) { return new \WP_Error("rest_forbidden", __(\NeoRenameBeta\NeoGlobal\neo__("Image not found.", "Bild nicht gefunden."), "wp-rest-api"), ["status" => 404]); }
    
    $title_error = rename_update_title($img_id, $get_param("title"));
    if (is_wp_error($title_error)) { return $title_error; }
    $slug_error = rename_update_slug($img_id, $get_param("slug"));
    if (is_wp_error($slug_error)) { return $slug_error; }
    $file_rename_error = interface_rename_media_file_20250302($img_id, $get_param("filename"));
    if (is_wp_error($file_rename_error)) { return $file_rename_error; }
    
    return [
        "imgUrl"  => wp_get_attachment_url($img_id),
        "title"    => get_post_field("post_title", $img_id),
        "slug"     => get_post_field("post_name", $img_id),
        "filename" => basename(get_attached_file($img_id)),
    ];
});



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/rename-info", "GET", "editor", function ($get_param) {
    
    $img_url = $get_param("img-url");
    $img_id = attachment_url_to_postid($img_url);
    if ($img_id == 0) { return new \WP_Error("rest_forbidden", __(\NeoRenameBeta\NeoGlobal\neo__("Image not found.", "Bild nicht gefunden."), "wp-rest-api"), ["status" => 404]); }
    
    return [
        "title" => get_post_field("post_title", $img_id, context: "raw"),
        "slug"  => get_post_field("post_name",  $img_id, context: "raw"),
        "filename" => basename(get_attached_file($img_id)),
    ];
});


\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/rename-unique", "GET", "editor", function ($get_param) {
    
    $img_url = $get_param("img-url");
    $filename = $get_param("filename");
    $slug = $get_param("slug");
    
    $image_id = attachment_url_to_postid($img_url);
    if ($image_id == 0) { return new \WP_Error("rest_forbidden", __(\NeoRenameBeta\NeoGlobal\neo__("Image not found.", "Bild nicht gefunden."), "wp-rest-api"), ["status" => 404]); }
    $image_path = get_attached_file($image_id);
    $image_path = realpath($image_path);
    $image_dir = dirname($image_path);
    if (basename($img_url) == $filename) {
        $unique_filename = $filename;
    } else {
        $unique_filename = wp_unique_filename($image_dir, $filename);
    }

    $old_slug = get_post_field("post_name", $image_id);
    if ($slug == $old_slug) {
        $unique_slug = $slug;
    } else {
        $unique_slug = wp_unique_post_slug($slug, $image_id, get_post_field("post_status", $image_id), get_post_field("post_type", $image_id), get_post_field("post_parent", $image_id));
    }

    return ["filename" => $unique_filename, "slug" => $unique_slug];
});
