import { rename } from "./neo-rename.js";
import { extractJson } from "./_global--extract-json.js";
import { neoError } from "./_global--log.js";


window.neoRenameBulk = async function (sourceSlugRegex, targetSlugWithPlaceholders) { 
    console.log("Loading all images..."); 
    const allImages = await fetch(neoRenameBulkData.imageListEndpointUrl, { headers: { "X-WP-Nonce": neoRenameBulkData.imageListEndpointNonce } }).then(extractJson); 
    const renameCommands = allImages.map(({ slug, imgUrl }) => { 
        if (!sourceSlugRegex.test(slug)) { return null; } 
        const originalExtension = imgUrl.split(".").pop(); 
        const targetSlug = slug.replace(sourceSlugRegex, targetSlugWithPlaceholders); 
        if (targetSlug.includes("$")) { throw new Error(`Target slug "${targetSlug}" contains "$". Did you forget to add brackets to your source regex?`); } 
        const targetFilename = `${targetSlug}.${originalExtension}`; 
        return { sourceSlug: slug, sourceImgUrl: imgUrl, targetSlug, targetFilename };
    }).filter(Boolean); 
    if (JSON.stringify(window.neoRenameBulk.confirmedRenameCommands) !== JSON.stringify(renameCommands)) { 
        console.log("Please confirm that you want to rename the following images:"); 
        const renameCommandsOnlySlugs = {}; for (const renameCommand of renameCommands) { renameCommandsOnlySlugs[renameCommand.sourceSlug] = renameCommand.targetSlug; } 
        console.table(renameCommandsOnlySlugs); 
        window.neoRenameBulk.confirmedRenameCommands = renameCommands; 
        console.log("To confirm, run the function again (arrow up, then enter)."); 
        return; 
    }
    for (const renameCommand of renameCommands) { 
        console.log(`Renaming "${renameCommand.sourceSlug}" to "${renameCommand.targetSlug}"...`); 
        try { await rename(renameCommand.sourceImgUrl, { filename: renameCommand.targetFilename, slug: renameCommand.targetSlug, title: renameCommand.targetSlug }); } 
        catch (e) { neoError(`Failed to rename image "${renameCommand.sourceSlug}" to "${renameCommand.targetSlug}":`, e); } 
    }
    console.log("%cDone!", "color: green;"); 
};
