<?php
namespace NeoRenameBeta\NeoRename;


\NeoRenameBeta\NeoGlobal\add_action_hook("admin_enqueue_scripts", function () { \NeoRenameBeta\NeoGlobal\enqueue_js("neo-rename-bulk.js", "neoRenameBulkData", ["imageListEndpointUrl" => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/rename-list-images"), "imageListEndpointNonce" => wp_create_nonce("wp_rest")]); });



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/rename-list-images", "GET", "admin", function ($get_param) {
    $media_query = new \WP_Query([
        "post_type"      => "attachment",
        "post_status"    => "inherit",
        "posts_per_page" => -1,
    ]);
    $media_files = $media_query->get_posts();
    return array_map(function ($media_file) { return [ "slug" => $media_file->post_name, "imgUrl" => wp_get_attachment_url($media_file->ID) ]; }, $media_files);
});
