<?php
namespace NeoRenameBeta\NeoRename;


function interface_rename_dialog_init_20250302() {
    \NeoRenameBeta\NeoGlobal\enqueue_js("neo-rename-dialog.js", "neoRenameData", [
        "renameEndpointUrl"       => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/rename"),
        "renameEndpointNonce"     => wp_create_nonce("wp_rest"),
        "renameInfoEndpointUrl"   => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/rename-info"),
        "renameInfoEndpointNonce" => wp_create_nonce("wp_rest"),
        "renameUniqueEndpointUrl" => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/rename-unique"),
        "renameUniqueEndpointNonce" => wp_create_nonce("wp_rest"),
        "pluginUrl" => \NeoRenameBeta\NeoGlobal\plugin_url(),
    ]);
    \NeoRenameBeta\NeoGlobal\enqueue_css("neo-rename-dialog.css");
}


\NeoRenameBeta\NeoGlobal\add_action_hook("current_screen", function () {
    global $pagenow;
    if ($pagenow !== "upload.php") { return; }
    interface_rename_dialog_init_20250302();
});


\NeoRenameBeta\NeoGlobal\add_filter_hook("media_row_actions", function ($actions, $img_post, $detached) {
    if (!current_user_can("upload_files")) { return $actions; }
    $img_url = wp_get_attachment_url($img_post->ID);
    
    $actions["neo_rename"] = '<button class="button-link neo-media-library-inline-rename-button"'
                            . ' data-neo-img-url="' . $img_url . '">'
                            . \NeoRenameBeta\NeoGlobal\neo__("neoRename", "neoRename") . '</button>';
    return $actions;
});
