import { neoWarn } from "./_global--log.js";
import { extractJson } from "./_global--extract-json.js";

export async function rename(imgUrl, { filename, slug, title }) {
    const response = await fetch(neoRenameData.renameEndpointUrl, {
        method: "POST",
        headers: { "Content-Type": "application/json", "X-WP-Nonce": neoRenameData.renameEndpointNonce }, 
        body: JSON.stringify({ "img-url": imgUrl, "filename": filename, "slug": slug, "title": title }) 
    });
    if (!response.ok) { let errorMessage = await response.text(); try { errorMessage = extractJson(errorMessage).message || errorMessage; } catch (e) { neoWarn(e); } throw new Error(errorMessage); } 
    return await extractJson(response); 
}
