<?php
namespace NeoRenameBeta\NeoEntrypoint;
/*
* Plugin Name: neoRename Beta
* Plugin URI: https://neo-wp.com?plugin-slug=neo-rename&edition=beta
* Description: Efficiently rename images and maximize SEO ranking!
* Version: 25.7.2.b015636
* Requires PHP: 8.0
* Requires at least: 5.9
* Author: neoWP
* Author URI: https://neo-wp.com
* License: General Public License v2
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
* Edition: beta
* Bundle Slug: neo-rename-beta
* Filename: neo-rename-beta.25.7.2.b015636.zip
* Date: 2025-07-02 03:57:02 (Europe/Berlin)
* Country of Origin: Made in Germany
*/


if (!function_exists('\NeoRenameBeta\NeoEntrypoint\neo_dummy_function')) { function neo_dummy_function() {}

    
    function read_plugin_infos($force_refresh = false) {
        static $plugin_info_cache = null;
        if ($force_refresh) { $plugin_info_cache = null; }
        $plugin_info_cache ??= json_decode(file_get_contents(str_replace(".php", ".json", __FILE__)), true);
        return $plugin_info_cache;
    }

    function plugin_slug()                  { return read_plugin_infos()["plugin_slug"]; }
    function plugin_edition()               { return read_plugin_infos()["plugin_edition"]; }
    function plugin_version()               { return read_plugin_infos()["plugin_version"]; }
    function plugin_contributors()          { return read_plugin_infos()["plugin_contributors"]; }
    function plugin_timestamp()             { return read_plugin_infos()["plugin_timestamp"]; }
    function plugin_namespace_prefix()      { return read_plugin_infos()["plugin_namespace_prefix"]; }
    function plugin_min_php_ver()           { return read_plugin_infos()["plugin_min_php_ver"]; }
    function plugin_min_wp_ver()            { return read_plugin_infos()["plugin_min_wp_ver"]; }
    function plugin_license()               { return read_plugin_infos()["plugin_license"]; }
    function plugin_license_uri()           { return read_plugin_infos()["plugin_license_uri"]; }
    function plugin_supported_os_families() { return read_plugin_infos()["plugin_supported_os_families"]; }
    function plugin_author()                { return read_plugin_infos()["plugin_author"]; }
    function plugin_author_uri()            { return read_plugin_infos()["plugin_author_uri"]; }
    function plugin_author_a_tag()          { return read_plugin_infos()["plugin_author_a_tag"]; }
    function plugin_author_profile()        { return read_plugin_infos()["plugin_author_profile"]; }
    function plugin_entry_file_path()       { return __FILE__; }
    function plugin_menu_slug()             { return "neowp"; }


    
    
    $GLOBALS["neo_core_callback_master"]           ??= null;
    $GLOBALS["neo_core_callback_master_timestamp"] ??= null;
    function register_core_callback_master($callback) {
        if (!($GLOBALS["neo_core_callback_master_timestamp"] === null || $GLOBALS["neo_core_callback_master_timestamp"] < plugin_timestamp())) { return; }
        $GLOBALS["neo_core_callback_master_timestamp"] = plugin_timestamp();
        $GLOBALS["neo_core_callback_master"] = $callback;
    }
    $GLOBALS["neo_core_is_first_run"] ??= true; if ($GLOBALS["neo_core_is_first_run"]) { $GLOBALS["neo_core_is_first_run"] = false;
        
        add_action("plugins_loaded", function () { if ($GLOBALS["neo_core_callback_master"] !== null) { $GLOBALS["neo_core_callback_master"](); } });
    }



    

    
    function suppress_plugin($message) {
        
        setcookie("neosuppress", "true", time() + (20), "/");
        echo '<script>document.cookie = "neosuppress=true; path=/; max-age=' . strval((20)) . '";</script>';
        $_COOKIE["neosuppress"] = "true";
        
        update_option("neo-suppress-message", $message);
    }

    function suppress_plugin_on_error($callback) {
        try { return $callback(); }
        catch (\Throwable $e) {
            $error_message = $e->getMessage() . " [" . basename($e->getFile()) . ":" . $e->getLine() . "]";
            if (str_contains($error_message, "#ignoreNeoSuppress")) { throw $e; }
            if (defined("WP_CLI")) { \WP_CLI::error($error_message); }
            else { suppress_plugin($error_message); }
            
            if (get_option("neo-debug-error-message-extended", "false") === "true") {
                \add_filter("wp_php_error_message", function ($message) use ($e) {
                    
                    $raw_trace = preg_replace("/(^|\n)#\d+ /", "\n", $e->getTraceAsString());
                    $frames = explode("\n", $raw_trace); array_unshift($frames, $e->getFile() . "(" . $e->getLine() . "): " . get_class($e));
                    
                    $html_trace = implode("", array_map(function ($frame) {
                        if (trim($frame) === "") { return ""; }
                        $frame = preg_replace_callback('/((?:\/|[A-Z]:\\\\)[^\s:]+\.php)\((\d+)\): (.*)$/', function ($m) {
                            $file_path = $m[1];
                            $error_row = (int) $m[2]; $error_row_html = (string) $error_row;
                            $code_string = file_exists($file_path) ? file_get_contents($file_path) : "// Datei nicht gefunden, um Fehler einzugrenzen";
                            $ace_editor_id = "ace_stack_" . uniqid("", false);
                            $short_path = str_replace(["/var/www/" . ($_SERVER["HTTP_HOST"] ?? ""), "/var/www/neowp/neowp"], "", $file_path);
                            $js_code = "<script>
                                // Ace-Editor für Code-Ansicht mit Syntax-Highlighting initialisieren
                                (async function aceInit() { // ACE-Editor initialisieren
                                    if (!window.ace) { setTimeout(aceInit, 50); return; } // Warten, bis Ace geladen ist
                                    ace.config.set('basePath', 'https://cdnjs.cloudflare.com/ajax/libs/ace/1.41.0/'); // Base-Pfad für Ace-Editor setzen
                                    const editor = ace.edit(" . json_encode($ace_editor_id, JSON_UNESCAPED_UNICODE) ."); // ID für Ace-Editor setzen
                                    editor.session.setMode('ace/mode/php'); // PHP-Syntax-Highlighting aktivieren
                                    editor.setOptions({ readOnly: true, highlightActiveLine: false, highlightGutterLine: false, showPrintMargin: false, highlightIndentGuides: true }); // Einstellungen für Ace-Editor setzen. readOnly -> Nur-Lese-Modus, highlightActiveLine und highlightGutterLine -> Zeile mit Textcusor nicht grau hervorheben, showPrintMargin -> Kein Druckrand, highlightIndentGuides -> Einrückungshilfen markieren, wenn entsprechende Klammer ausgewählt
                                    editor.setValue(" . json_encode($code_string, JSON_UNESCAPED_UNICODE). ", -1);  // Code in den Ace-Editor laden, -1 -> Cursor an den Anfang setzen
                                    await new Promise(resolve => setTimeout(resolve, 0)); // Ein Frame abwarten, damit der Code gerendert ist, weil sonst das Markieren der Codezeile unten nicht funktioniert.
                                    const Range = ace.require('ace/range').Range; // Range-Objekt für Ace-Editor importieren
                                    const lineNumberZeroBased = " . ($error_row - 1) . "; // Zu markierende Zeile nullbasiert setzen, weil Ace-Editor nullbasiert ist
                                    editor.session.addMarker(new Range(lineNumberZeroBased, 0, lineNumberZeroBased, 10000), 'ace_error_line', 'line'); // Marker für die Fehlerzeile setzen, bis Spalte 10000, damit der gesamte Code bis zur Zeile markiert wird
                                    editor.scrollToLine(lineNumberZeroBased, true, true, function() {}); // Editor zur Fehlerzeile scrollen
                                    document.addEventListener('pointermove', () => editor.scrollToLine(lineNumberZeroBased, true, true, function() {}), { once: true }); // Nach einer Nutzerinteraktion noch einmal an die richtige Stelle scrollen, weil sonst der Code zum Scrollen nicht funktioniert, wenn der Tab im Hintergrund geöffnet wird.
                                })();
                            </script>";
                            return '<b title="' . esc_attr($file_path) . '">' . $short_path . ":" . $error_row_html . "</b><br><div id=\"" . $ace_editor_id . "\" style=\"width:100%;height:200px;border:1px solid #ddd;\"></div>" . $js_code;
                        }, $frame);
                        return '<div class="stack-frame">' . $frame . '</div>';
                    }, $frames));

                    $ace_js = "<script src=\"https://cdnjs.cloudflare.com/ajax/libs/ace/1.41.0/ace.js\" crossorigin=\"anonymous\"></script>";
                    $css_styles = '<style> /* CSS-Styling für die Fehlerseite */
                        body#error-page { display: flex; flex-direction: column; } /* Display Flex für order eins weiter unten */
                        .wp-die-message { order: -1; } /* Unsere Fehlerseite über der nativ von PHP ausgegebenen Fehlermeldung anzeigen. order -> Einfachste Möglichkeit, das zu tun. */
                        .ace_error_line { position: absolute; background-color: rgba(255, 0, 0, 0.15); } /* Fehlerzeile im Ace-Editor rot */
                        .stack-frame { margin-bottom:12px; } /* Abstand zwischen Stack-Frames */
                    </style>';
                    return $ace_js
                        . "<h1>Error - " . ($_SERVER["HTTP_HOST"] ?? "") . "</h1>"
                        . get_class($e) . "<br><br>"
                        . $e->getMessage() . "<br><br>"
                        . $html_trace . "<br><br>"
                        . $message
                        . $css_styles;
                });
            }
            throw $e;
        }
    }


    suppress_plugin_on_error(function () {
        $neo_plugin_load_time_before = microtime(true);
        
        if (isset($_GET["neosuppress"])) {
            suppress_plugin("Plugin is suppressed by ?neosuppress in the URL.");
        }
        if (isset($_GET["neoundosuppress"])) {
            setcookie("neosuppress", "", time() - 3600, "/");
            unset($_COOKIE["neosuppress"]);
        }
        if (!empty($_COOKIE["neosuppress"])) {
            
            if (!isset($GLOBALS["neo_suppress_message_shown"])) { $GLOBALS["neo_suppress_message_shown"] = true;
                add_action("admin_notices", function() {?><div class="error"><p>neoPlugins are temporarily suppressed (20s). Reason: <?php echo esc_html(get_option("neo-suppress-message")) ?> <a href="<?php echo add_query_arg("neoundosuppress", "", remove_query_arg("neosuppress")) ?>">Re-enable now</a></p></div><?php });
                add_action("wp_footer", function() {?><div style="position: fixed; bottom: 0; left: 0; right: 0; background: #f00; color: #fff; padding: 10px;">neoPlugins are temporarily suppressed (20s). Reason: <?php echo esc_html(get_option("neo-suppress-message")) ?> <a style="text-decoration:underline;" href="<?php echo add_query_arg("neoundosuppress", "", remove_query_arg("neosuppress")) ?>">Re-enable now</a></div><?php });
            }

            if (($_GET["page"] ?? null) === "neowp") { header("Location: " . admin_url()); exit; }
            
            return;
        }
        if (empty($_COOKIE["neosuppress"])) {
            delete_option("neo-suppress-message");
        }


        $neo_load_error_message = null;
        if (!in_array(PHP_OS_FAMILY, plugin_supported_os_families()))             { $neo_load_error_message = "neoPlugin is inactive because it is only supported on " . implode(", ", plugin_supported_os_families()) . ", not on " . PHP_OS_FAMILY . "."; }
        if (!version_compare(PHP_VERSION, plugin_min_php_ver(), ">="))            { $neo_load_error_message = "neoPlugin is inactive because PHP is too old (" . PHP_VERSION . " < " . plugin_min_php_ver() . ")."; }
        if (!version_compare(get_bloginfo("version"), plugin_min_wp_ver(), ">=")) { $neo_load_error_message = "neoPlugin is inactive because WP is too old (" . get_bloginfo("version") . " < " . plugin_min_wp_ver() . ")."; }

        
        if ($neo_load_error_message) {
            if (defined("WP_CLI")) { \WP_CLI::error($neo_load_error_message); }
            else { add_action("admin_notices", function() use ($neo_load_error_message) { echo '<div class="error"><p>' . esc_html($neo_load_error_message) . '</p></div>'; }); }
            return;
        }


        $plugin_php_file_paths_relative = [];
        foreach (scandir(dirname(__FILE__)) as $plugin_file_name) {
            if ($plugin_file_name === "." || $plugin_file_name === "..") { continue; }
            if (!is_file(dirname(__FILE__) . "/" . $plugin_file_name)) { continue; }
            if (!str_ends_with($plugin_file_name, ".php")) { continue; }
            $plugin_php_file_paths_relative[] = $plugin_file_name;
        }
        sort($plugin_php_file_paths_relative);

        
        function _neo_entry_function_get_module_name($rel_path) {
            if (str_starts_with($rel_path, "_global")) { return "neo-global"; }
            return implode("-", array_slice(explode("-", explode(".", explode("/", $rel_path)[0])[0]), 0, 2));
        }


        $global_files = [];
        $module_files = [];
        foreach ($plugin_php_file_paths_relative as $rel_path) {
            if (!str_ends_with($rel_path, ".php"))        { continue; }
            if ($rel_path === basename(__FILE__))         { continue; }
            if ($rel_path === "live-update" . ".php")     { continue; }
            if (str_starts_with($rel_path, "_global-")) { $global_files[] = $rel_path; }
            else { $module_files[_neo_entry_function_get_module_name($rel_path)][] = $rel_path; }
        }


        $global_files = array_merge(["_global--performance.php"], array_values(array_diff($global_files, ["_global--performance.php"])));
        
        
        $GLOBALS["neo_active_plugins"] ??= [];
        $GLOBALS["neo_active_plugins"][] = ["slug" => plugin_slug(), "edition" => plugin_edition(), "version" => plugin_version(), "namespace_prefix" => plugin_namespace_prefix(), "plugin_path" => dirname(__FILE__), "plugin_entry_file_path" => plugin_entry_file_path(), "global_files" => $global_files, "module_files" => $module_files];
        
        
        
        register_core_callback_master(function () use ($neo_plugin_load_time_before, $module_files) {
            suppress_plugin_on_error(function () use ($neo_plugin_load_time_before, $module_files) {
                
                $live_update_time_before = microtime(true);
                if (file_exists(dirname(__FILE__) . "/" . "live-update" . ".php")) { (fn () => require_once(dirname(__FILE__) . "/" . "live-update" . ".php"))(); }
                $live_update_time_after = microtime(true);

                
                (fn () => require_once(dirname(__FILE__) . "/" . "_global--performance.php"))();
                \NeoRenameBeta\NeoGlobal\performance_checkpoint("START PLUGIN", time: $neo_plugin_load_time_before, is_start: true);
                \NeoRenameBeta\NeoGlobal\performance_checkpoint("live update",  time: $live_update_time_before,     is_start: true);
                \NeoRenameBeta\NeoGlobal\performance_checkpoint("live update",  time: $live_update_time_after,      is_end: true);
                \NeoRenameBeta\NeoGlobal\performance_checkpoint("plugin-load", is_start: true);

                
                usort($GLOBALS["neo_active_plugins"], function ($plugin_a, $plugin_b) {
                    
                    $get_score = function ($a, $b) {                             $score  =     0;
                        if ($a["edition"] === "dev")                           { $score += 10000; }
                        if ($a["edition"] === "beta")                          { $score +=  1000; }
                        if ($a["edition"] === "pro")                           { $score +=   100; }
                        if (version_compare($a["version"], $b["version"]) > 0) { $score +=    10; }
                        if ($a["edition"] === "full")                          { $score +=     1; }
                        return $score;
                    };
                    return $get_score($plugin_b, $plugin_a) <=> $get_score($plugin_a, $plugin_b);
                });


                foreach ($GLOBALS["neo_active_plugins"] as $plugin) {
                    
                    foreach ($plugin["global_files"] as $global_file) {
                        \NeoRenameBeta\NeoGlobal\performance_checkpoint("load $global_file", is_start: true);
                        (fn () => require_once($plugin["plugin_path"] . "/" . $global_file))();
                        \NeoRenameBeta\NeoGlobal\performance_checkpoint("load $global_file", is_end: true);
                    }
                }


                
                $executed_modules = [];
                $suppressed_modules = in_array("neo-pro", array_keys($module_files)) ? json_decode(get_option("neo-managerpro-suppressed-modules", "[]")) : [];
                foreach ($GLOBALS["neo_active_plugins"] as $active_plugin) {
                    foreach ($active_plugin["module_files"] as $module_slug => $module_files) {
                        if (in_array($module_slug, ["neo-website", "neo-websiteneowp"])) { continue; }
                        if (in_array($module_slug, $suppressed_modules)) { $executed_modules[]= $module_slug; continue; }
                        if (in_array($module_slug, $executed_modules)) { continue; }
                        $executed_modules[] = $module_slug;
                        foreach ($module_files as $module_file) {
                            \NeoRenameBeta\NeoGlobal\performance_checkpoint("load $module_file", is_start: true);
                            (fn () => require_once($active_plugin["plugin_path"] . "/" . $module_file))();
                            \NeoRenameBeta\NeoGlobal\performance_checkpoint("load $module_file", is_end: true);
                        }
                    }
                }


                do_action("neo_init");
            });
        });


        try {
            if (file_exists(dirname(__FILE__) . "/" . "_global-freemius" . ".php")) { (fn () => require_once(dirname(__FILE__) . "/" . "_global-freemius" . ".php"))(); }
            (fn () => require_once(dirname(__FILE__) . "/" . "_global-activate-deactivate-uninstall.php"))();
        } catch (\Throwable $e) {
            trigger_error("Error while loading activate/deactivate/uninstall hooks: " . $e->getMessage(), E_USER_WARNING);
        }
    });


    function get_neo_active_plugins() { return $GLOBALS["neo_active_plugins"] ?? []; }
}
