import { observeClick } from "./_global--observer.js";
import { neo__ } from "./_global-translation.js";
import { reloadPage } from "./_global-reload-curtain.js";
import Swal from "./_global-sweetalert2.js";


observeClick(".neo-reset-button", async (buttonNode) => { 
    const resetAction = buttonNode.getAttribute("data-neo-reset-action"); 
    const buttonTextBefore = buttonNode.innerHTML; 
    buttonNode.style.width = buttonNode.offsetWidth + "px"; 
    buttonNode.innerText = "..."; 
    try { 
        const response = await fetch(neoResetData.resetEndpointUrl, {
            method: "POST",
            headers: { "Content-Type": "application/json", "X-WP-Nonce": neoResetData.resetEndpointNonce },
            body: JSON.stringify({ "reset-action": resetAction }),
        });
        if (!response.ok) { throw new Error("Error: " + await response.text()); } 
        buttonNode.innerText = neo__("Success", "Erfolg"); 
        buttonNode.style.backgroundColor = "darkgreen"; 
        await new Promise((resolve) => setTimeout(resolve, (1) * 1000)); 
        reloadPage(); 
    } catch (error) { 
        Swal.fire({
            icon: "error",
            title: neo__("Error while resetting", "Fehler beim Zurücksetzen"),
            text: error.message,
            showCloseButton: true,
            confirmButtonText: neo__("OK", "OK"),
        });
        buttonNode.innerHTML = buttonTextBefore; 
        buttonNode.style.width = ""; 
    }
});
