<?php
namespace NeoRenameBeta\NeoReset;



\NeoRenameBeta\NeoGlobal\add_action_hook("neo_init", function () {

    $menu_render_callback = function () {?>
        <div style="display: flex; flex-direction: column;">
            <p><?php echo \NeoRenameBeta\NeoGlobal\neo__("Reset the plugin to its original state, as if freshly installed.", "Setze das Plugin in den Ursprungszustand zurück, als wäre es frisch installiert.") ?></p>
            <div style="display: flex; flex-direction: row; flex-wrap: wrap;">
                <a class="button button-primary neo-reset-button" 
                    title="<?php echo esc_attr(\NeoRenameBeta\NeoGlobal\neo__("Clear all cache folders and third-party caches", "Alle Cache-Ordner und Drittanbieter-Caches löschen") . (file_exists(\NeoRenameBeta\NeoGlobal\cache_path() . "/" . "custom-gpt") ? \NeoRenameBeta\NeoGlobal\neo__(" except custom-gpt", "außer custom-gpt") : ""))?>"
                    data-neo-reset-action="clear-cache" href="javascript:void()">
                    <?php echo \NeoRenameBeta\NeoGlobal\neo__("Clear cache", "Cache leeren") ?>
                </a>
                &nbsp;<a class="button button-primary neo-reset-button" data-neo-reset-action="delete-settings" href="javascript:void()"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Reset settings", "Einstellungen zurücksetzen") ?></a>
                <?php if (\NeoRenameBeta\NeoGlobal\is_module_available("neo-pluginupdate")) {?>
                    &nbsp;<a class="button button-primary neo-reset-button" data-neo-reset-action="force-update-check" href="javascript:void()"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Check for updates now", "Jetzt auf Updates prüfen") ?></a>
                <?php } ?>
                <?php if (\NeoRenameBeta\NeoGlobal\is_module_available("neo-freemius")) {?>
                    &nbsp;<a class="button button-primary neo-reset-button" data-neo-reset-action="delete-license-cache" href="javascript:void()" title="<?php echo esc_attr(\NeoRenameBeta\NeoGlobal\neo__("Deletes the license check cache and keeps the license itself.", "Löscht den Lizenzprüfungs-Cache und behält die Lizenz selbst."))                          ?>"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Delete license cache", "Lizenz-Cache löschen") ?></a>
                    &nbsp;<a class="button button-primary neo-reset-button" data-neo-reset-action="delete-license"       href="javascript:void()" title="<?php echo esc_attr(\NeoRenameBeta\NeoGlobal\neo__("Deletes all license data. The license key has to be entered again.", "Löscht sämtliche Lizenzdaten. Der Lizenzsschlüssel muss erneut eingegeben werden.")) ?>"><?php echo \NeoRenameBeta\NeoGlobal\neo__("Delete all license data", "Alle Lizenz-Daten löschen") ?></a>
                <?php } ?>
            </div>
        </div>
    <?php };
    \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoMenu\interface_add_neo_menu_page_20250604')(
        id: "neo-reset",
        icon: \NeoRenameBeta\NeoGlobal\plugin_url() . "/img/plugin-module-neo-reset-icon.svg",
        title: \NeoRenameBeta\NeoGlobal\neo__("neoReset", "neoReset"),
        description: \NeoRenameBeta\NeoGlobal\neo__("Here we go again.", "Auf ein Neues."),
        render_callback: $menu_render_callback
    );

    $enqueue_assets_callback = function () { \NeoRenameBeta\NeoGlobal\enqueue_js("neo-reset.js", "neoResetData", ["resetEndpointUrl" => \NeoRenameBeta\NeoGlobal\get_rest_endpoint_url("/wp-json/neo/neo-reset"), "resetEndpointNonce" => wp_create_nonce("wp_rest") ]); };
    \NeoRenameBeta\NeoGlobal\call_interface_func_bundled('\NeoRenameBeta\NeoMenu\interface_add_neo_menu_asset_loading_callback_20250302')($enqueue_assets_callback);
});



\NeoRenameBeta\NeoGlobal\register_rest_endpoint("/wp-json/neo/neo-reset", "POST", "admin", function ($get_param) {
    $reset_action = $get_param("reset-action");
    if ($reset_action === "clear-cache") {
        \NeoRenameBeta\NeoGlobal\clear_cache();
        return "OKAY";
    } else if ($reset_action === "delete-settings") {
        \NeoRenameBeta\NeoGlobal\delete_all_plugin_options();
        return "OKAY";
    } else if ($reset_action === "force-update-check") {
        \NeoRenameBeta\NeoGlobal\delete_all(\NeoRenameBeta\NeoGlobal\cache_path("neo-pluginupdate"));
        delete_site_transient("update_plugins");
        return "OKAY";
    } else if ($reset_action === "delete-license-cache") {

        \NeoRenameBeta\NeoGlobal\delete_all(\NeoRenameBeta\NeoGlobal\cache_path("neo-pro"));
        return "OKAY";
    } else if ($reset_action === "delete-license") {
        
        foreach (array_keys(wp_load_alloptions()) as $option_name) {
            if (!(str_starts_with($option_name, "fs_") || str_starts_with($option_name, "_site_transient_fs_"))) { continue; }
            delete_option($option_name);
        }

        \NeoRenameBeta\NeoGlobal\delete_all(\NeoRenameBeta\NeoGlobal\cache_path("neo-pro"));
        return "OKAY";
    } else {
        throw new \NeoRenameBeta\NeoGlobal\GlobalException("Invalid reset action: " . $reset_action);
    }
});
